#pragma once

typedef enum {
#ifdef TARGET_X86_64KVM
    RAX_64 = 0,
    RCX_64 = 2,
    RDX_64 = 3,
    RBX_64 = 1,
    RSP_64 = 4,
    RBP_64 = 5,
    RSI_64 = 6,
    RDI_64 = 7,
    R8_64 = 8,
    R9_64 = 9,
    R10_64 = 10,
    R11_64 = 11,
    R12_64 = 12,
    R13_64 = 13,
    R14_64 = 14,
    R15_64 = 15,
    RIP_64 = 16,
    EFLAGS_64 = 17,
    CS_64 = 18,
    SS_64 = 19,
    DS_64 = 20,
    ES_64 = 21,
    FS_64 = 22,
    GS_64 = 23,
    ST0_64 = 24,
    ST1_64 = 25,
    ST2_64 = 26,
    ST3_64 = 27,
    ST4_64 = 28,
    ST5_64 = 29,
    ST6_64 = 30,
    ST7_64 = 31,
    CR0_64 = 32,
    CR1_64 = 33,
    CR2_64 = 34,
    CR3_64 = 35,
    CR4_64 = 36,
    CR8_64 = 40,
    EFER_64 = 41,
#else
    EAX_32 = 0,
    ECX_32 = 1,
    EDX_32 = 2,
    EBX_32 = 3,
    ESP_32 = 4,
    EBP_32 = 5,
    ESI_32 = 6,
    EDI_32 = 7,
    EIP_32 = 8,
    EFLAGS_32 = 9,
    CS_32 = 10,
    SS_32 = 11,
    DS_32 = 12,
    ES_32 = 13,
    FS_32 = 14,
    GS_32 = 15,
    ST0_32 = 16,
    ST1_32 = 17,
    ST2_32 = 18,
    ST3_32 = 19,
    ST4_32 = 20,
    ST5_32 = 21,
    ST6_32 = 22,
    ST7_32 = 23,
    CR0_32 = 24,
    CR1_32 = 25,
    CR2_32 = 26,
    CR3_32 = 27,
    CR4_32 = 28,
#endif
} Registers;

#ifdef TARGET_X86_64KVM
#define RAX    RAX_64
#define RCX    RCX_64
#define RDX    RDX_64
#define RBX    RBX_64
#define RSP    RSP_64
#define RBP    RBP_64
#define RSI    RSI_64
#define RDI    RDI_64
#define R8     R8_64
#define R9     R9_64
#define R10    R10_64
#define R11    R11_64
#define R12    R12_64
#define R13    R13_64
#define R14    R14_64
#define R15    R15_64
#define RIP    RIP_64
#define EFLAGS EFLAGS_64
#define CS     CS_64
#define SS     SS_64
#define DS     DS_64
#define ES     ES_64
#define FS     FS_64
#define GS     GS_64
#define ST0    ST0_64
#define ST1    ST1_64
#define ST2    ST2_64
#define ST3    ST3_64
#define ST4    ST4_64
#define ST5    ST5_64
#define ST6    ST6_64
#define ST7    ST7_64
#define CR0    CR0_64
#define CR1    CR1_64
#define CR2    CR2_64
#define CR3    CR3_64
#define CR4    CR4_64
#define CR8    CR8_64
#define EFER   EFER_64
#else
#define RAX    EAX_32
#define RCX    ECX_32
#define RDX    EDX_32
#define RBX    EBX_32
#define RSP    ESP_32
#define RBP    EBP_32
#define RSI    ESI_32
#define RDI    EDI_32
#define RIP    EIP_32
#define EFLAGS EFLAGS_32
#define CS     CS_32
#define SS     SS_32
#define DS     DS_32
#define ES     ES_32
#define FS     FS_32
#define GS     GS_32
#define ST0    ST0_32
#define ST1    ST1_32
#define ST2    ST2_32
#define ST3    ST3_32
#define ST4    ST4_32
#define ST5    ST5_32
#define ST6    ST6_32
#define ST7    ST7_32
#define CR0    CR0_32
#define CR1    CR1_32
#define CR2    CR2_32
#define CR3    CR3_32
#define CR4    CR4_32
#endif
