// Generated by PeakRDL-renode

using Antmicro.Renode.Core.Structure.Registers;
using Antmicro.Renode.Peripherals.Bus;

namespace Antmicro.Renode.Peripherals.I3C
{
    public partial class Caliptra_I3C : IProvidesRegisterCollection<DoubleWordRegisterCollection>, IPeripheral, IDoubleWordPeripheral
    {
        /// <summary> Register "HCI_VERSION" at 0x0 </summary>
        protected HciVersionType HciVersion;
        /// <summary> Register "HC_CONTROL" at 0x4 </summary>
        protected HcControlType HcControl;
        /// <summary> Register "CONTROLLER_DEVICE_ADDR" at 0x8 </summary>
        protected ControllerDeviceAddrType ControllerDeviceAddr;
        /// <summary> Register "HC_CAPABILITIES" at 0xc </summary>
        protected HcCapabilitiesType HcCapabilities;
        /// <summary> Register "RESET_CONTROL" at 0x10 </summary>
        protected ResetControlType ResetControl;
        /// <summary> Register "PRESENT_STATE" at 0x14 </summary>
        protected PresentStateType PresentState;
        /// <summary> Register "INTR_STATUS" at 0x20 </summary>
        protected IntrStatusType IntrStatus;
        /// <summary> Register "INTR_STATUS_ENABLE" at 0x24 </summary>
        protected IntrStatusEnableType IntrStatusEnable;
        /// <summary> Register "INTR_SIGNAL_ENABLE" at 0x28 </summary>
        protected IntrSignalEnableType IntrSignalEnable;
        /// <summary> Register "INTR_FORCE" at 0x2c </summary>
        protected IntrForceType IntrForce;
        /// <summary> Register "DAT_SECTION_OFFSET" at 0x30 </summary>
        protected DatSectionOffsetType DatSectionOffset;
        /// <summary> Register "DCT_SECTION_OFFSET" at 0x34 </summary>
        protected DctSectionOffsetType DctSectionOffset;
        /// <summary> Register "RING_HEADERS_SECTION_OFFSET" at 0x38 </summary>
        protected RingHeadersSectionOffsetType RingHeadersSectionOffset;
        /// <summary> Register "PIO_SECTION_OFFSET" at 0x3c </summary>
        protected PioSectionOffsetType PioSectionOffset;
        /// <summary> Register "EXT_CAPS_SECTION_OFFSET" at 0x40 </summary>
        protected ExtCapsSectionOffsetType ExtCapsSectionOffset;
        /// <summary> Register "INT_CTRL_CMDS_EN" at 0x4c </summary>
        protected IntCtrlCmdsEnType IntCtrlCmdsEn;
        /// <summary> Register "IBI_NOTIFY_CTRL" at 0x58 </summary>
        protected IbiNotifyCtrlType IbiNotifyCtrl;
        /// <summary> Register "IBI_DATA_ABORT_CTRL" at 0x5c </summary>
        protected IbiDataAbortCtrlType IbiDataAbortCtrl;
        /// <summary> Register "DEV_CTX_BASE_LO" at 0x60 </summary>
        protected DevCtxBaseLoType DevCtxBaseLo;
        /// <summary> Register "DEV_CTX_BASE_HI" at 0x64 </summary>
        protected DevCtxBaseHiType DevCtxBaseHi;
        /// <summary> Register "DEV_CTX_SG" at 0x68 </summary>
        protected DevCtxSgType DevCtxSg;
        /// <summary> Register "COMMAND_PORT" at 0x80 </summary>
        protected CommandPortType CommandPort;
        /// <summary> Register "RESPONSE_PORT" at 0x84 </summary>
        protected ResponsePortType ResponsePort;
        /// <summary> Register "TX_DATA_PORT" at 0x88 and Register "RX_DATA_PORT" at 0x88 </summary>
        protected PIOTxRxDataPortType PIOTxRxDataPort;
        /// <summary> Register "IBI_PORT" at 0x8c </summary>
        protected PIOIbiPortType PIOIbiPort;
        /// <summary> Register "QUEUE_THLD_CTRL" at 0x90 </summary>
        protected PIOQueueThldCtrlType PIOQueueThldCtrl;
        /// <summary> Register "DATA_BUFFER_THLD_CTRL" at 0x94 </summary>
        protected PIODataBufferThldCtrlType PIODataBufferThldCtrl;
        /// <summary> Register "QUEUE_SIZE" at 0x98 </summary>
        protected PIOQueueSizeType PIOQueueSize;
        /// <summary> Register "ALT_QUEUE_SIZE" at 0x9c </summary>
        protected AltQueueSizeType AltQueueSize;
        /// <summary> Register "PIO_INTR_STATUS" at 0xa0 </summary>
        protected PioIntrStatusType PioIntrStatus;
        /// <summary> Register "PIO_INTR_STATUS_ENABLE" at 0xa4 </summary>
        protected PioIntrStatusEnableType PioIntrStatusEnable;
        /// <summary> Register "PIO_INTR_SIGNAL_ENABLE" at 0xa8 </summary>
        protected PioIntrSignalEnableType PioIntrSignalEnable;
        /// <summary> Register "PIO_INTR_FORCE" at 0xac </summary>
        protected PioIntrForceType PioIntrForce;
        /// <summary> Register "PIO_CONTROL" at 0xb0 </summary>
        protected PioControlType PioControl;
        /// <summary> Register "EXTCAP_HEADER" at 0x100 </summary>
        protected SecureFirmwareRecoveryInterfaceExtcapHeaderType SecureFirmwareRecoveryInterfaceExtcapHeader;
        /// <summary> Register "PROT_CAP_0" at 0x104 </summary>
        protected ProtCap0Type ProtCap0;
        /// <summary> Register "PROT_CAP_1" at 0x108 </summary>
        protected ProtCap1Type ProtCap1;
        /// <summary> Register "PROT_CAP_2" at 0x10c </summary>
        protected ProtCap2Type ProtCap2;
        /// <summary> Register "PROT_CAP_3" at 0x110 </summary>
        protected ProtCap3Type ProtCap3;
        /// <summary> Register "DEVICE_ID_0" at 0x114 </summary>
        protected DeviceId0Type DeviceId0;
        /// <summary> Register "DEVICE_ID_1" at 0x118 </summary>
        protected DeviceId1Type DeviceId1;
        /// <summary> Register "DEVICE_ID_2" at 0x11c </summary>
        protected DeviceId2Type DeviceId2;
        /// <summary> Register "DEVICE_ID_3" at 0x120 </summary>
        protected DeviceId3Type DeviceId3;
        /// <summary> Register "DEVICE_ID_4" at 0x124 </summary>
        protected DeviceId4Type DeviceId4;
        /// <summary> Register "DEVICE_ID_5" at 0x128 </summary>
        protected DeviceId5Type DeviceId5;
        /// <summary> Register "DEVICE_ID_RESERVED" at 0x12c </summary>
        protected DeviceIdReservedType DeviceIdReserved;
        /// <summary> Register "DEVICE_STATUS_0" at 0x130 </summary>
        protected DeviceStatus0Type DeviceStatus0;
        /// <summary> Register "DEVICE_STATUS_1" at 0x134 </summary>
        protected DeviceStatus1Type DeviceStatus1;
        /// <summary> Register "DEVICE_RESET" at 0x138 </summary>
        protected DeviceResetType DeviceReset;
        /// <summary> Register "RECOVERY_CTRL" at 0x13c </summary>
        protected RecoveryCtrlType RecoveryCtrl;
        /// <summary> Register "RECOVERY_STATUS" at 0x140 </summary>
        protected RecoveryStatusType RecoveryStatus;
        /// <summary> Register "HW_STATUS" at 0x144 </summary>
        protected HwStatusType HwStatus;
        /// <summary> Register "INDIRECT_FIFO_CTRL_0" at 0x148 </summary>
        protected IndirectFifoCtrl0Type IndirectFifoCtrl0;
        /// <summary> Register "INDIRECT_FIFO_CTRL_1" at 0x14c </summary>
        protected IndirectFifoCtrl1Type IndirectFifoCtrl1;
        /// <summary> Register "INDIRECT_FIFO_STATUS_0" at 0x150 </summary>
        protected IndirectFifoStatus0Type IndirectFifoStatus0;
        /// <summary> Register "INDIRECT_FIFO_STATUS_1" at 0x154 </summary>
        protected IndirectFifoStatus1Type IndirectFifoStatus1;
        /// <summary> Register "INDIRECT_FIFO_STATUS_2" at 0x158 </summary>
        protected IndirectFifoStatus2Type IndirectFifoStatus2;
        /// <summary> Register "INDIRECT_FIFO_STATUS_3" at 0x15c </summary>
        protected IndirectFifoStatus3Type IndirectFifoStatus3;
        /// <summary> Register "INDIRECT_FIFO_STATUS_4" at 0x160 </summary>
        protected IndirectFifoStatus4Type IndirectFifoStatus4;
        /// <summary> Register "INDIRECT_FIFO_RESERVED" at 0x164 </summary>
        protected IndirectFifoReservedType IndirectFifoReserved;
        /// <summary> Register "INDIRECT_FIFO_DATA" at 0x168 </summary>
        protected IndirectFifoDataType IndirectFifoData;
        /// <summary> Register "EXTCAP_HEADER" at 0x180 </summary>
        protected StandbyControllerModeRegistersExtcapHeaderType StandbyControllerModeRegistersExtcapHeader;
        /// <summary> Register "STBY_CR_CONTROL" at 0x184 </summary>
        protected StbyCrControlType StbyCrControl;
        /// <summary> Register "STBY_CR_DEVICE_ADDR" at 0x188 </summary>
        protected StbyCrDeviceAddrType StbyCrDeviceAddr;
        /// <summary> Register "STBY_CR_CAPABILITIES" at 0x18c </summary>
        protected StbyCrCapabilitiesType StbyCrCapabilities;
        /// <summary> Register "__rsvd_0" at 0x190 </summary>
        protected Rsvd0Type Rsvd0;
        /// <summary> Register "STBY_CR_STATUS" at 0x194 </summary>
        protected StbyCrStatusType StbyCrStatus;
        /// <summary> Register "STBY_CR_DEVICE_CHAR" at 0x198 </summary>
        protected StbyCrDeviceCharType StbyCrDeviceChar;
        /// <summary> Register "STBY_CR_DEVICE_PID_LO" at 0x19c </summary>
        protected StbyCrDevicePidLoType StbyCrDevicePidLo;
        /// <summary> Register "STBY_CR_INTR_STATUS" at 0x1a0 </summary>
        protected StbyCrIntrStatusType StbyCrIntrStatus;
        /// <summary> Register "__rsvd_1" at 0x1a4 </summary>
        protected Rsvd1Type Rsvd1;
        /// <summary> Register "STBY_CR_INTR_SIGNAL_ENABLE" at 0x1a8 </summary>
        protected StbyCrIntrSignalEnableType StbyCrIntrSignalEnable;
        /// <summary> Register "STBY_CR_INTR_FORCE" at 0x1ac </summary>
        protected StbyCrIntrForceType StbyCrIntrForce;
        /// <summary> Register "STBY_CR_CCC_CONFIG_GETCAPS" at 0x1b0 </summary>
        protected StbyCrCccConfigGetcapsType StbyCrCccConfigGetcaps;
        /// <summary> Register "STBY_CR_CCC_CONFIG_RSTACT_PARAMS" at 0x1b4 </summary>
        protected StbyCrCccConfigRstactParamsType StbyCrCccConfigRstactParams;
        /// <summary> Register "STBY_CR_VIRT_DEVICE_ADDR" at 0x1b8 </summary>
        protected StbyCrVirtDeviceAddrType StbyCrVirtDeviceAddr;
        /// <summary> Register "__rsvd_3" at 0x1bc </summary>
        protected Rsvd3Type Rsvd3;
        /// <summary> Register "EXTCAP_HEADER" at 0x1c0 </summary>
        protected TargetTransactionInterfaceRegistersExtcapHeaderType TargetTransactionInterfaceRegistersExtcapHeader;
        /// <summary> Register "CONTROL" at 0x1c4 </summary>
        protected ControlType Control;
        /// <summary> Register "STATUS" at 0x1c8 </summary>
        protected StatusType Status;
        /// <summary> Register "RESET_CONTROL" at 0x1cc </summary>
        protected TargetTransactionInterfaceResetControlType TargetTransactionInterfaceResetControl;
        /// <summary> Register "INTERRUPT_STATUS" at 0x1d0 </summary>
        protected InterruptStatusType InterruptStatus;
        /// <summary> Register "INTERRUPT_ENABLE" at 0x1d4 </summary>
        protected InterruptEnableType InterruptEnable;
        /// <summary> Register "INTERRUPT_FORCE" at 0x1d8 </summary>
        protected InterruptForceType InterruptForce;
        /// <summary> Register "RX_DESC_QUEUE_PORT" at 0x1dc </summary>
        protected RxDescQueuePortType RxDescQueuePort;
        /// <summary> Register "RX_DATA_PORT" at 0x1e0 </summary>
        protected TargetTransactionInterfaceRxDataPortType TargetTransactionInterfaceRxDataPort;
        /// <summary> Register "TX_DESC_QUEUE_PORT" at 0x1e4 </summary>
        protected TxDescQueuePortType TxDescQueuePort;
        /// <summary> Register "TX_DATA_PORT" at 0x1e8 </summary>
        protected TargetTransactionInterfaceTxDataPortType TargetTransactionInterfaceTxDataPort;
        /// <summary> Register "IBI_PORT" at 0x1ec </summary>
        protected TargetTransactionInterfaceIbiPortType TargetTransactionInterfaceIbiPort;
        /// <summary> Register "QUEUE_SIZE" at 0x1f0 </summary>
        protected TargetTransactionInterfaceQueueSizeType TargetTransactionInterfaceQueueSize;
        /// <summary> Register "IBI_QUEUE_SIZE" at 0x1f4 </summary>
        protected IbiQueueSizeType IbiQueueSize;
        /// <summary> Register "QUEUE_THLD_CTRL" at 0x1f8 </summary>
        protected TargetTransactionInterfaceQueueThldCtrlType TargetTransactionInterfaceQueueThldCtrl;
        /// <summary> Register "DATA_BUFFER_THLD_CTRL" at 0x1fc </summary>
        protected TargetTransactionInterfaceDataBufferThldCtrlType TargetTransactionInterfaceDataBufferThldCtrl;
        /// <summary> Register "EXTCAP_HEADER" at 0x200 </summary>
        protected SoCManagementInterfaceRegistersExtcapHeaderType SoCManagementInterfaceRegistersExtcapHeader;
        /// <summary> Register "SOC_MGMT_CONTROL" at 0x204 </summary>
        protected SocMgmtControlType SocMgmtControl;
        /// <summary> Register "SOC_MGMT_STATUS" at 0x208 </summary>
        protected SocMgmtStatusType SocMgmtStatus;
        /// <summary> Register "SOC_MGMT_RSVD_0" at 0x20c </summary>
        protected SocMgmtRsvd0Type SocMgmtRsvd0;
        /// <summary> Register "SOC_MGMT_RSVD_1" at 0x210 </summary>
        protected SocMgmtRsvd1Type SocMgmtRsvd1;
        /// <summary> Register "SOC_MGMT_RSVD_2" at 0x214 </summary>
        protected SocMgmtRsvd2Type SocMgmtRsvd2;
        /// <summary> Register "SOC_MGMT_RSVD_3" at 0x218 </summary>
        protected SocMgmtRsvd3Type SocMgmtRsvd3;
        /// <summary> Register "SOC_PAD_CONF" at 0x21c </summary>
        protected SocPadConfType SocPadConf;
        /// <summary> Register "SOC_PAD_ATTR" at 0x220 </summary>
        protected SocPadAttrType SocPadAttr;
        /// <summary> Register "SOC_MGMT_FEATURE_2" at 0x224 </summary>
        protected SocMgmtFeature2Type SocMgmtFeature2;
        /// <summary> Register "SOC_MGMT_FEATURE_3" at 0x228 </summary>
        protected SocMgmtFeature3Type SocMgmtFeature3;
        /// <summary> Register "T_R_REG" at 0x22c </summary>
        protected TRRegType TRReg;
        /// <summary> Register "T_F_REG" at 0x230 </summary>
        protected TFRegType TFReg;
        /// <summary> Register "T_SU_DAT_REG" at 0x234 </summary>
        protected TSuDatRegType TSuDatReg;
        /// <summary> Register "T_HD_DAT_REG" at 0x238 </summary>
        protected THdDatRegType THdDatReg;
        /// <summary> Register "T_HIGH_REG" at 0x23c </summary>
        protected THighRegType THighReg;
        /// <summary> Register "T_LOW_REG" at 0x240 </summary>
        protected TLowRegType TLowReg;
        /// <summary> Register "T_HD_STA_REG" at 0x244 </summary>
        protected THdStaRegType THdStaReg;
        /// <summary> Register "T_SU_STA_REG" at 0x248 </summary>
        protected TSuStaRegType TSuStaReg;
        /// <summary> Register "T_SU_STO_REG" at 0x24c </summary>
        protected TSuStoRegType TSuStoReg;
        /// <summary> Register "T_FREE_REG" at 0x250 </summary>
        protected TFreeRegType TFreeReg;
        /// <summary> Register "T_AVAL_REG" at 0x254 </summary>
        protected TAvalRegType TAvalReg;
        /// <summary> Register "T_IDLE_REG" at 0x258 </summary>
        protected TIdleRegType TIdleReg;
        /// <summary> Register "EXTCAP_HEADER" at 0x260 </summary>
        protected ControllerConfigRegistersExtcapHeaderType ControllerConfigRegistersExtcapHeader;
        /// <summary> Register "CONTROLLER_CONFIG" at 0x264 </summary>
        protected ControllerConfigType ControllerConfig;
        /// <summary> Register "TERMINATION_EXTCAP_HEADER" at 0x268 </summary>
        protected TerminationExtcapHeaderType TerminationExtcapHeader;
        /// <summary> Memory "DAT" at 0x400 </summary>
        protected Dat_DatMemoryContainer Dat;
        /// <summary> Memory "DCT" at 0x800 </summary>
        protected Dct_DctMemoryContainer Dct;

        public DoubleWordRegisterCollection RegistersCollection { get; }

        public Caliptra_I3C()
        {
            RegistersCollection = new DoubleWordRegisterCollection(this);
            HciVersion = new HciVersionType(this);
            HcControl = new HcControlType(this);
            ControllerDeviceAddr = new ControllerDeviceAddrType(this);
            HcCapabilities = new HcCapabilitiesType(this);
            ResetControl = new ResetControlType(this);
            PresentState = new PresentStateType(this);
            IntrStatus = new IntrStatusType(this);
            IntrStatusEnable = new IntrStatusEnableType(this);
            IntrSignalEnable = new IntrSignalEnableType(this);
            IntrForce = new IntrForceType(this);
            DatSectionOffset = new DatSectionOffsetType(this);
            DctSectionOffset = new DctSectionOffsetType(this);
            RingHeadersSectionOffset = new RingHeadersSectionOffsetType(this);
            PioSectionOffset = new PioSectionOffsetType(this);
            ExtCapsSectionOffset = new ExtCapsSectionOffsetType(this);
            IntCtrlCmdsEn = new IntCtrlCmdsEnType(this);
            IbiNotifyCtrl = new IbiNotifyCtrlType(this);
            IbiDataAbortCtrl = new IbiDataAbortCtrlType(this);
            DevCtxBaseLo = new DevCtxBaseLoType(this);
            DevCtxBaseHi = new DevCtxBaseHiType(this);
            DevCtxSg = new DevCtxSgType(this);
            CommandPort = new CommandPortType(this);
            ResponsePort = new ResponsePortType(this);
            TargetTransactionInterfaceTxDataPort = new TargetTransactionInterfaceTxDataPortType(this);
            PIOIbiPort = new PIOIbiPortType(this);
            PIOQueueThldCtrl = new PIOQueueThldCtrlType(this);
            PIODataBufferThldCtrl = new PIODataBufferThldCtrlType(this);
            PIOQueueSize = new PIOQueueSizeType(this);
            AltQueueSize = new AltQueueSizeType(this);
            PioIntrStatus = new PioIntrStatusType(this);
            PioIntrStatusEnable = new PioIntrStatusEnableType(this);
            PioIntrSignalEnable = new PioIntrSignalEnableType(this);
            PioIntrForce = new PioIntrForceType(this);
            PioControl = new PioControlType(this);
            SecureFirmwareRecoveryInterfaceExtcapHeader = new SecureFirmwareRecoveryInterfaceExtcapHeaderType(this);
            ProtCap0 = new ProtCap0Type(this);
            ProtCap1 = new ProtCap1Type(this);
            ProtCap2 = new ProtCap2Type(this);
            ProtCap3 = new ProtCap3Type(this);
            DeviceId0 = new DeviceId0Type(this);
            DeviceId1 = new DeviceId1Type(this);
            DeviceId2 = new DeviceId2Type(this);
            DeviceId3 = new DeviceId3Type(this);
            DeviceId4 = new DeviceId4Type(this);
            DeviceId5 = new DeviceId5Type(this);
            DeviceIdReserved = new DeviceIdReservedType(this);
            DeviceStatus0 = new DeviceStatus0Type(this);
            DeviceStatus1 = new DeviceStatus1Type(this);
            DeviceReset = new DeviceResetType(this);
            RecoveryCtrl = new RecoveryCtrlType(this);
            RecoveryStatus = new RecoveryStatusType(this);
            HwStatus = new HwStatusType(this);
            IndirectFifoCtrl0 = new IndirectFifoCtrl0Type(this);
            IndirectFifoCtrl1 = new IndirectFifoCtrl1Type(this);
            IndirectFifoStatus0 = new IndirectFifoStatus0Type(this);
            IndirectFifoStatus1 = new IndirectFifoStatus1Type(this);
            IndirectFifoStatus2 = new IndirectFifoStatus2Type(this);
            IndirectFifoStatus3 = new IndirectFifoStatus3Type(this);
            IndirectFifoStatus4 = new IndirectFifoStatus4Type(this);
            IndirectFifoReserved = new IndirectFifoReservedType(this);
            IndirectFifoData = new IndirectFifoDataType(this);
            StandbyControllerModeRegistersExtcapHeader = new StandbyControllerModeRegistersExtcapHeaderType(this);
            StbyCrControl = new StbyCrControlType(this);
            StbyCrDeviceAddr = new StbyCrDeviceAddrType(this);
            StbyCrCapabilities = new StbyCrCapabilitiesType(this);
            Rsvd0 = new Rsvd0Type(this);
            StbyCrStatus = new StbyCrStatusType(this);
            StbyCrDeviceChar = new StbyCrDeviceCharType(this);
            StbyCrDevicePidLo = new StbyCrDevicePidLoType(this);
            StbyCrIntrStatus = new StbyCrIntrStatusType(this);
            Rsvd1 = new Rsvd1Type(this);
            StbyCrIntrSignalEnable = new StbyCrIntrSignalEnableType(this);
            StbyCrIntrForce = new StbyCrIntrForceType(this);
            StbyCrCccConfigGetcaps = new StbyCrCccConfigGetcapsType(this);
            StbyCrCccConfigRstactParams = new StbyCrCccConfigRstactParamsType(this);
            StbyCrVirtDeviceAddr = new StbyCrVirtDeviceAddrType(this);
            Rsvd3 = new Rsvd3Type(this);
            TargetTransactionInterfaceRegistersExtcapHeader = new TargetTransactionInterfaceRegistersExtcapHeaderType(this);
            Control = new ControlType(this);
            Status = new StatusType(this);
            TargetTransactionInterfaceResetControl = new TargetTransactionInterfaceResetControlType(this);
            InterruptStatus = new InterruptStatusType(this);
            InterruptEnable = new InterruptEnableType(this);
            InterruptForce = new InterruptForceType(this);
            RxDescQueuePort = new RxDescQueuePortType(this);
            TxDescQueuePort = new TxDescQueuePortType(this);
            PIOTxRxDataPort = new PIOTxRxDataPortType(this);
            TargetTransactionInterfaceIbiPort = new TargetTransactionInterfaceIbiPortType(this);
            TargetTransactionInterfaceQueueSize = new TargetTransactionInterfaceQueueSizeType(this);
            IbiQueueSize = new IbiQueueSizeType(this);
            TargetTransactionInterfaceQueueThldCtrl = new TargetTransactionInterfaceQueueThldCtrlType(this);
            TargetTransactionInterfaceDataBufferThldCtrl = new TargetTransactionInterfaceDataBufferThldCtrlType(this);
            SoCManagementInterfaceRegistersExtcapHeader = new SoCManagementInterfaceRegistersExtcapHeaderType(this);
            SocMgmtControl = new SocMgmtControlType(this);
            SocMgmtStatus = new SocMgmtStatusType(this);
            SocMgmtRsvd0 = new SocMgmtRsvd0Type(this);
            SocMgmtRsvd1 = new SocMgmtRsvd1Type(this);
            SocMgmtRsvd2 = new SocMgmtRsvd2Type(this);
            SocMgmtRsvd3 = new SocMgmtRsvd3Type(this);
            SocPadConf = new SocPadConfType(this);
            SocPadAttr = new SocPadAttrType(this);
            SocMgmtFeature2 = new SocMgmtFeature2Type(this);
            SocMgmtFeature3 = new SocMgmtFeature3Type(this);
            TRReg = new TRRegType(this);
            TFReg = new TFRegType(this);
            TSuDatReg = new TSuDatRegType(this);
            THdDatReg = new THdDatRegType(this);
            THighReg = new THighRegType(this);
            TLowReg = new TLowRegType(this);
            THdStaReg = new THdStaRegType(this);
            TSuStaReg = new TSuStaRegType(this);
            TSuStoReg = new TSuStoRegType(this);
            TFreeReg = new TFreeRegType(this);
            TAvalReg = new TAvalRegType(this);
            TIdleReg = new TIdleRegType(this);
            ControllerConfigRegistersExtcapHeader = new ControllerConfigRegistersExtcapHeaderType(this);
            ControllerConfig = new ControllerConfigType(this);
            TerminationExtcapHeader = new TerminationExtcapHeaderType(this);
            Dat = new Dat_DatMemoryContainer();
            Dct = new Dct_DctMemoryContainer();
            this.Init();
        }

        partial void Init();

        partial void Reset();

        void IPeripheral.Reset()
        {
            this.Reset();
            RegistersCollection.Reset();
        }

        uint IDoubleWordPeripheral.ReadDoubleWord(long offset)
        {
            if(offset >= 1024 && offset < 1024L + Dat.Size)
            {
                return Dat.ReadDoubleWord(offset - 1024);
            }
            if(offset >= 2048 && offset < 2048L + Dct.Size)
            {
                return Dct.ReadDoubleWord(offset - 2048);
            }
            return RegistersCollection.Read(offset);
        }

        void IDoubleWordPeripheral.WriteDoubleWord(long offset, uint value)
        {
            if(offset >= 1024 && offset < 1024L + Dat.Size)
            {
                Dat.WriteDoubleWord(offset - 1024, value);
                return;
            }
            if(offset >= 2048 && offset < 2048L + Dct.Size)
            {
                Dct.WriteDoubleWord(offset - 2048, value);
                return;
            }
            RegistersCollection.Write(offset, value);
        }

        public struct HciVersionType
        {
            /// <summary> Field "VERSION" at 0x0, width: 32 bits </summary>
            public IValueRegisterField VERSION;

            public HciVersionType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(0, 4294967295, true)
                    .WithValueField(0, 32, out VERSION, mode: FieldMode.Read, name: "VERSION");
            }
        }

        public struct HcControlType
        {
            /// <summary> Field "IBA_INCLUDE" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField IBA_INCLUDE;
            /// <summary> Field "AUTOCMD_DATA_RPT" at 0x3, width: 1 bits </summary>
            public IFlagRegisterField AUTOCMD_DATA_RPT;
            /// <summary> Field "DATA_BYTE_ORDER_MODE" at 0x4, width: 1 bits </summary>
            public IFlagRegisterField DATA_BYTE_ORDER_MODE;
            /// <summary> Field "MODE_SELECTOR" at 0x6, width: 1 bits </summary>
            public IFlagRegisterField MODE_SELECTOR;
            /// <summary> Field "I2C_DEV_PRESENT" at 0x7, width: 1 bits </summary>
            public IFlagRegisterField I2C_DEV_PRESENT;
            /// <summary> Field "HOT_JOIN_CTRL" at 0x8, width: 1 bits </summary>
            public IFlagRegisterField HOT_JOIN_CTRL;
            /// <summary> Field "HALT_ON_CMD_SEQ_TIMEOUT" at 0xc, width: 1 bits </summary>
            public IFlagRegisterField HALT_ON_CMD_SEQ_TIMEOUT;
            /// <summary> Field "ABORT" at 0x1d, width: 1 bits </summary>
            public IFlagRegisterField ABORT;
            /// <summary> Field "RESUME" at 0x1e, width: 1 bits </summary>
            public IFlagRegisterField RESUME;
            /// <summary> Field "BUS_ENABLE" at 0x1f, width: 1 bits </summary>
            public IFlagRegisterField BUS_ENABLE;

            public HcControlType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(4, 64, true)
                    .WithFlag(0, out IBA_INCLUDE, name: "IBA_INCLUDE")
                    .WithFlag(3, out AUTOCMD_DATA_RPT, mode: FieldMode.Read, name: "AUTOCMD_DATA_RPT")
                    .WithFlag(4, out DATA_BYTE_ORDER_MODE, mode: FieldMode.Read, name: "DATA_BYTE_ORDER_MODE")
                    .WithFlag(6, out MODE_SELECTOR, mode: FieldMode.Read, name: "MODE_SELECTOR")
                    .WithFlag(7, out I2C_DEV_PRESENT, name: "I2C_DEV_PRESENT")
                    .WithFlag(8, out HOT_JOIN_CTRL, name: "HOT_JOIN_CTRL")
                    .WithFlag(12, out HALT_ON_CMD_SEQ_TIMEOUT, name: "HALT_ON_CMD_SEQ_TIMEOUT")
                    .WithFlag(29, out ABORT, name: "ABORT")
                    .WithFlag(30, out RESUME, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "RESUME")
                    .WithFlag(31, out BUS_ENABLE, name: "BUS_ENABLE");
            }
        }

        public struct ControllerDeviceAddrType
        {
            /// <summary> Field "DYNAMIC_ADDR" at 0x10, width: 7 bits </summary>
            public IValueRegisterField DYNAMIC_ADDR;
            /// <summary> Field "DYNAMIC_ADDR_VALID" at 0x1f, width: 1 bits </summary>
            public IFlagRegisterField DYNAMIC_ADDR_VALID;

            public ControllerDeviceAddrType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(8, 0, true)
                    .WithValueField(16, 7, out DYNAMIC_ADDR, name: "DYNAMIC_ADDR")
                    .WithFlag(31, out DYNAMIC_ADDR_VALID, name: "DYNAMIC_ADDR_VALID");
            }
        }

        public struct ResetControlType
        {
            public IFlagRegisterField SOFT_RST;
            public IFlagRegisterField CMD_QUEUE_RST;
            public IFlagRegisterField RESP_QUEUE_RST;
            public IFlagRegisterField TX_FIFO_RST;
            public IFlagRegisterField RX_FIFO_RST;
            public IFlagRegisterField IBI_QUEUE_RST;

            public ResetControlType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(16, 0)
                    .WithFlag(0, out SOFT_RST, name: "SOFT_RST")
                    .WithFlag(1, out CMD_QUEUE_RST, name: "CMD_QUEUE_RST")
                    .WithFlag(2, out RESP_QUEUE_RST, name: "RESP_QUEUE_RST")
                    .WithFlag(3, out TX_FIFO_RST, name: "TX_FIFO_RST")
                    .WithFlag(4, out RX_FIFO_RST, name: "RX_FIFO_RST")
                    .WithFlag(5, out IBI_QUEUE_RST, name: "IBI_QUEUE_RST");
            }
        }

        public struct HcCapabilitiesType
        {
            /// <summary> Field "COMBO_COMMAND" at 0x2, width: 1 bits </summary>
            public IFlagRegisterField COMBO_COMMAND;
            /// <summary> Field "AUTO_COMMAND" at 0x3, width: 1 bits </summary>
            public IFlagRegisterField AUTO_COMMAND;
            /// <summary> Field "STANDBY_CR_CAP" at 0x5, width: 1 bits </summary>
            public IFlagRegisterField STANDBY_CR_CAP;
            /// <summary> Field "HDR_DDR_EN" at 0x6, width: 1 bits </summary>
            public IFlagRegisterField HDR_DDR_EN;
            /// <summary> Field "HDR_TS_EN" at 0x7, width: 1 bits </summary>
            public IFlagRegisterField HDR_TS_EN;
            /// <summary> Field "CMD_CCC_DEFBYTE" at 0xa, width: 1 bits </summary>
            public IFlagRegisterField CMD_CCC_DEFBYTE;
            /// <summary> Field "IBI_DATA_ABORT_EN" at 0xb, width: 1 bits </summary>
            public IFlagRegisterField IBI_DATA_ABORT_EN;
            /// <summary> Field "IBI_CREDIT_COUNT_EN" at 0xc, width: 1 bits </summary>
            public IFlagRegisterField IBI_CREDIT_COUNT_EN;
            /// <summary> Field "SCHEDULED_COMMANDS_EN" at 0xd, width: 1 bits </summary>
            public IFlagRegisterField SCHEDULED_COMMANDS_EN;
            /// <summary> Field "CMD_SIZE" at 0x14, width: 2 bits </summary>
            public IValueRegisterField CMD_SIZE;
            /// <summary> Field "SG_CAPABILITY_CR_EN" at 0x1c, width: 1 bits </summary>
            public IFlagRegisterField SG_CAPABILITY_CR_EN;
            /// <summary> Field "SG_CAPABILITY_IBI_EN" at 0x1d, width: 1 bits </summary>
            public IFlagRegisterField SG_CAPABILITY_IBI_EN;
            /// <summary> Field "SG_CAPABILITY_DC_EN" at 0x1e, width: 1 bits </summary>
            public IFlagRegisterField SG_CAPABILITY_DC_EN;

            public HcCapabilitiesType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(12, 1024, true)
                    .WithFlag(2, out COMBO_COMMAND, mode: FieldMode.Read, name: "COMBO_COMMAND")
                    .WithFlag(3, out AUTO_COMMAND, mode: FieldMode.Read, name: "AUTO_COMMAND")
                    .WithFlag(5, out STANDBY_CR_CAP, mode: FieldMode.Read, name: "STANDBY_CR_CAP")
                    .WithFlag(6, out HDR_DDR_EN, mode: FieldMode.Read, name: "HDR_DDR_EN")
                    .WithFlag(7, out HDR_TS_EN, mode: FieldMode.Read, name: "HDR_TS_EN")
                    .WithFlag(10, out CMD_CCC_DEFBYTE, mode: FieldMode.Read, name: "CMD_CCC_DEFBYTE")
                    .WithFlag(11, out IBI_DATA_ABORT_EN, mode: FieldMode.Read, name: "IBI_DATA_ABORT_EN")
                    .WithFlag(12, out IBI_CREDIT_COUNT_EN, mode: FieldMode.Read, name: "IBI_CREDIT_COUNT_EN")
                    .WithFlag(13, out SCHEDULED_COMMANDS_EN, mode: FieldMode.Read, name: "SCHEDULED_COMMANDS_EN")
                    .WithValueField(20, 2, out CMD_SIZE, mode: FieldMode.Read, name: "CMD_SIZE")
                    .WithFlag(28, out SG_CAPABILITY_CR_EN, mode: FieldMode.Read, name: "SG_CAPABILITY_CR_EN")
                    .WithFlag(29, out SG_CAPABILITY_IBI_EN, mode: FieldMode.Read, name: "SG_CAPABILITY_IBI_EN")
                    .WithFlag(30, out SG_CAPABILITY_DC_EN, mode: FieldMode.Read, name: "SG_CAPABILITY_DC_EN");
            }
        }

        public struct TargetTransactionInterfaceResetControlType
        {
            /// <summary> Field "SOFT_RST" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField SOFT_RST;
            /// <summary> Field "TX_DESC_RST" at 0x1, width: 1 bits </summary>
            public IFlagRegisterField TX_DESC_RST;
            /// <summary> Field "RX_DESC_RST" at 0x2, width: 1 bits </summary>
            public IFlagRegisterField RX_DESC_RST;
            /// <summary> Field "TX_DATA_RST" at 0x3, width: 1 bits </summary>
            public IFlagRegisterField TX_DATA_RST;
            /// <summary> Field "RX_DATA_RST" at 0x4, width: 1 bits </summary>
            public IFlagRegisterField RX_DATA_RST;
            /// <summary> Field "IBI_QUEUE_RST" at 0x5, width: 1 bits </summary>
            public IFlagRegisterField IBI_QUEUE_RST;

            public TargetTransactionInterfaceResetControlType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(460, 0, true)
                    .WithFlag(0, out SOFT_RST, name: "SOFT_RST")
                    .WithFlag(1, out TX_DESC_RST, name: "TX_DESC_RST")
                    .WithFlag(2, out RX_DESC_RST, name: "RX_DESC_RST")
                    .WithFlag(3, out TX_DATA_RST, name: "TX_DATA_RST")
                    .WithFlag(4, out RX_DATA_RST, name: "RX_DATA_RST")
                    .WithFlag(5, out IBI_QUEUE_RST, name: "IBI_QUEUE_RST");
            }
        }

        public struct PresentStateType
        {
            /// <summary> Field "AC_CURRENT_OWN" at 0x2, width: 1 bits </summary>
            public IFlagRegisterField AC_CURRENT_OWN;

            public PresentStateType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(20, 0, true)
                    .WithFlag(2, out AC_CURRENT_OWN, mode: FieldMode.Read, name: "AC_CURRENT_OWN");
            }
        }

        public struct IntrStatusType
        {
            /// <summary> Field "HC_INTERNAL_ERR_STAT" at 0xa, width: 1 bits </summary>
            public IFlagRegisterField HC_INTERNAL_ERR_STAT;
            /// <summary> Field "HC_SEQ_CANCEL_STAT" at 0xb, width: 1 bits </summary>
            public IFlagRegisterField HC_SEQ_CANCEL_STAT;
            /// <summary> Field "HC_WARN_CMD_SEQ_STALL_STAT" at 0xc, width: 1 bits </summary>
            public IFlagRegisterField HC_WARN_CMD_SEQ_STALL_STAT;
            /// <summary> Field "HC_ERR_CMD_SEQ_TIMEOUT_STAT" at 0xd, width: 1 bits </summary>
            public IFlagRegisterField HC_ERR_CMD_SEQ_TIMEOUT_STAT;
            /// <summary> Field "SCHED_CMD_MISSED_TICK_STAT" at 0xe, width: 1 bits </summary>
            public IFlagRegisterField SCHED_CMD_MISSED_TICK_STAT;

            public IntrStatusType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(32, 0, true)
                    .WithFlag(10, out HC_INTERNAL_ERR_STAT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "HC_INTERNAL_ERR_STAT")
                    .WithFlag(11, out HC_SEQ_CANCEL_STAT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "HC_SEQ_CANCEL_STAT")
                    .WithFlag(12, out HC_WARN_CMD_SEQ_STALL_STAT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "HC_WARN_CMD_SEQ_STALL_STAT")
                    .WithFlag(13, out HC_ERR_CMD_SEQ_TIMEOUT_STAT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "HC_ERR_CMD_SEQ_TIMEOUT_STAT")
                    .WithFlag(14, out SCHED_CMD_MISSED_TICK_STAT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "SCHED_CMD_MISSED_TICK_STAT");
            }
        }

        public struct IntrStatusEnableType
        {
            /// <summary> Field "HC_INTERNAL_ERR_STAT_EN" at 0xa, width: 1 bits </summary>
            public IFlagRegisterField HC_INTERNAL_ERR_STAT_EN;
            /// <summary> Field "HC_SEQ_CANCEL_STAT_EN" at 0xb, width: 1 bits </summary>
            public IFlagRegisterField HC_SEQ_CANCEL_STAT_EN;
            /// <summary> Field "HC_WARN_CMD_SEQ_STALL_STAT_EN" at 0xc, width: 1 bits </summary>
            public IFlagRegisterField HC_WARN_CMD_SEQ_STALL_STAT_EN;
            /// <summary> Field "HC_ERR_CMD_SEQ_TIMEOUT_STAT_EN" at 0xd, width: 1 bits </summary>
            public IFlagRegisterField HC_ERR_CMD_SEQ_TIMEOUT_STAT_EN;
            /// <summary> Field "SCHED_CMD_MISSED_TICK_STAT_EN" at 0xe, width: 1 bits </summary>
            public IFlagRegisterField SCHED_CMD_MISSED_TICK_STAT_EN;

            public IntrStatusEnableType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(36, 0, true)
                    .WithFlag(10, out HC_INTERNAL_ERR_STAT_EN, name: "HC_INTERNAL_ERR_STAT_EN")
                    .WithFlag(11, out HC_SEQ_CANCEL_STAT_EN, name: "HC_SEQ_CANCEL_STAT_EN")
                    .WithFlag(12, out HC_WARN_CMD_SEQ_STALL_STAT_EN, name: "HC_WARN_CMD_SEQ_STALL_STAT_EN")
                    .WithFlag(13, out HC_ERR_CMD_SEQ_TIMEOUT_STAT_EN, name: "HC_ERR_CMD_SEQ_TIMEOUT_STAT_EN")
                    .WithFlag(14, out SCHED_CMD_MISSED_TICK_STAT_EN, name: "SCHED_CMD_MISSED_TICK_STAT_EN");
            }
        }

        public struct IntrSignalEnableType
        {
            /// <summary> Field "HC_INTERNAL_ERR_SIGNAL_EN" at 0xa, width: 1 bits </summary>
            public IFlagRegisterField HC_INTERNAL_ERR_SIGNAL_EN;
            /// <summary> Field "HC_SEQ_CANCEL_SIGNAL_EN" at 0xb, width: 1 bits </summary>
            public IFlagRegisterField HC_SEQ_CANCEL_SIGNAL_EN;
            /// <summary> Field "HC_WARN_CMD_SEQ_STALL_SIGNAL_EN" at 0xc, width: 1 bits </summary>
            public IFlagRegisterField HC_WARN_CMD_SEQ_STALL_SIGNAL_EN;
            /// <summary> Field "HC_ERR_CMD_SEQ_TIMEOUT_SIGNAL_EN" at 0xd, width: 1 bits </summary>
            public IFlagRegisterField HC_ERR_CMD_SEQ_TIMEOUT_SIGNAL_EN;
            /// <summary> Field "SCHED_CMD_MISSED_TICK_SIGNAL_EN" at 0xe, width: 1 bits </summary>
            public IFlagRegisterField SCHED_CMD_MISSED_TICK_SIGNAL_EN;

            public IntrSignalEnableType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(40, 0, true)
                    .WithFlag(10, out HC_INTERNAL_ERR_SIGNAL_EN, name: "HC_INTERNAL_ERR_SIGNAL_EN")
                    .WithFlag(11, out HC_SEQ_CANCEL_SIGNAL_EN, name: "HC_SEQ_CANCEL_SIGNAL_EN")
                    .WithFlag(12, out HC_WARN_CMD_SEQ_STALL_SIGNAL_EN, name: "HC_WARN_CMD_SEQ_STALL_SIGNAL_EN")
                    .WithFlag(13, out HC_ERR_CMD_SEQ_TIMEOUT_SIGNAL_EN, name: "HC_ERR_CMD_SEQ_TIMEOUT_SIGNAL_EN")
                    .WithFlag(14, out SCHED_CMD_MISSED_TICK_SIGNAL_EN, name: "SCHED_CMD_MISSED_TICK_SIGNAL_EN");
            }
        }

        public struct IntrForceType
        {
            /// <summary> Field "HC_INTERNAL_ERR_FORCE" at 0xa, width: 1 bits </summary>
            public IFlagRegisterField HC_INTERNAL_ERR_FORCE;
            /// <summary> Field "HC_SEQ_CANCEL_FORCE" at 0xb, width: 1 bits </summary>
            public IFlagRegisterField HC_SEQ_CANCEL_FORCE;
            /// <summary> Field "HC_WARN_CMD_SEQ_STALL_FORCE" at 0xc, width: 1 bits </summary>
            public IFlagRegisterField HC_WARN_CMD_SEQ_STALL_FORCE;
            /// <summary> Field "HC_ERR_CMD_SEQ_TIMEOUT_FORCE" at 0xd, width: 1 bits </summary>
            public IFlagRegisterField HC_ERR_CMD_SEQ_TIMEOUT_FORCE;
            /// <summary> Field "SCHED_CMD_MISSED_TICK_FORCE" at 0xe, width: 1 bits </summary>
            public IFlagRegisterField SCHED_CMD_MISSED_TICK_FORCE;

            public IntrForceType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(44, 0, true)
                    .WithFlag(10, out HC_INTERNAL_ERR_FORCE, mode: FieldMode.Write, name: "HC_INTERNAL_ERR_FORCE")
                    .WithFlag(11, out HC_SEQ_CANCEL_FORCE, mode: FieldMode.Write, name: "HC_SEQ_CANCEL_FORCE")
                    .WithFlag(12, out HC_WARN_CMD_SEQ_STALL_FORCE, mode: FieldMode.Write, name: "HC_WARN_CMD_SEQ_STALL_FORCE")
                    .WithFlag(13, out HC_ERR_CMD_SEQ_TIMEOUT_FORCE, mode: FieldMode.Write, name: "HC_ERR_CMD_SEQ_TIMEOUT_FORCE")
                    .WithFlag(14, out SCHED_CMD_MISSED_TICK_FORCE, mode: FieldMode.Write, name: "SCHED_CMD_MISSED_TICK_FORCE");
            }
        }

        public struct DatSectionOffsetType
        {
            /// <summary> Field "TABLE_OFFSET" at 0x0, width: 12 bits </summary>
            public IValueRegisterField TABLE_OFFSET;
            /// <summary> Field "TABLE_SIZE" at 0xc, width: 7 bits </summary>
            public IValueRegisterField TABLE_SIZE;
            /// <summary> Field "ENTRY_SIZE" at 0x1c, width: 4 bits </summary>
            public IValueRegisterField ENTRY_SIZE;

            public DatSectionOffsetType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(48, 524287, true)
                    .WithValueField(0, 12, out TABLE_OFFSET, mode: FieldMode.Read, name: "TABLE_OFFSET")
                    .WithValueField(12, 7, out TABLE_SIZE, mode: FieldMode.Read, name: "TABLE_SIZE")
                    .WithValueField(28, 4, out ENTRY_SIZE, mode: FieldMode.Read, name: "ENTRY_SIZE");
            }
        }

        public struct DctSectionOffsetType
        {
            /// <summary> Field "TABLE_OFFSET" at 0x0, width: 12 bits </summary>
            public IValueRegisterField TABLE_OFFSET;
            /// <summary> Field "TABLE_SIZE" at 0xc, width: 7 bits </summary>
            public IValueRegisterField TABLE_SIZE;
            /// <summary> Field "TABLE_INDEX" at 0x13, width: 5 bits </summary>
            public IValueRegisterField TABLE_INDEX;
            /// <summary> Field "ENTRY_SIZE" at 0x1c, width: 4 bits </summary>
            public IValueRegisterField ENTRY_SIZE;

            public DctSectionOffsetType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(52, 524287, true)
                    .WithValueField(0, 12, out TABLE_OFFSET, mode: FieldMode.Read, name: "TABLE_OFFSET")
                    .WithValueField(12, 7, out TABLE_SIZE, mode: FieldMode.Read, name: "TABLE_SIZE")
                    .WithValueField(19, 5, out TABLE_INDEX, name: "TABLE_INDEX")
                    .WithValueField(28, 4, out ENTRY_SIZE, mode: FieldMode.Read, name: "ENTRY_SIZE");
            }
        }

        public struct RingHeadersSectionOffsetType
        {
            /// <summary> Field "SECTION_OFFSET" at 0x0, width: 16 bits </summary>
            public IValueRegisterField SECTION_OFFSET;

            public RingHeadersSectionOffsetType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(56, 0, true)
                    .WithValueField(0, 16, out SECTION_OFFSET, mode: FieldMode.Read, name: "SECTION_OFFSET");
            }
        }

        public struct PioSectionOffsetType
        {
            /// <summary> Field "SECTION_OFFSET" at 0x0, width: 16 bits </summary>
            public IValueRegisterField SECTION_OFFSET;

            public PioSectionOffsetType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(60, 65535, true)
                    .WithValueField(0, 16, out SECTION_OFFSET, mode: FieldMode.Read, name: "SECTION_OFFSET");
            }
        }

        public struct ExtCapsSectionOffsetType
        {
            /// <summary> Field "SECTION_OFFSET" at 0x0, width: 16 bits </summary>
            public IValueRegisterField SECTION_OFFSET;

            public ExtCapsSectionOffsetType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(64, 65535, true)
                    .WithValueField(0, 16, out SECTION_OFFSET, mode: FieldMode.Read, name: "SECTION_OFFSET");
            }
        }

        public struct IntCtrlCmdsEnType
        {
            /// <summary> Field "ICC_SUPPORT" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField ICC_SUPPORT;
            /// <summary> Field "MIPI_CMDS_SUPPORTED" at 0x1, width: 15 bits </summary>
            public IValueRegisterField MIPI_CMDS_SUPPORTED;

            public IntCtrlCmdsEnType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(76, 65535, true)
                    .WithFlag(0, out ICC_SUPPORT, mode: FieldMode.Read, name: "ICC_SUPPORT")
                    .WithValueField(1, 15, out MIPI_CMDS_SUPPORTED, mode: FieldMode.Read, name: "MIPI_CMDS_SUPPORTED");
            }
        }

        public struct IbiNotifyCtrlType
        {
            /// <summary> Field "NOTIFY_HJ_REJECTED" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField NOTIFY_HJ_REJECTED;
            /// <summary> Field "NOTIFY_CRR_REJECTED" at 0x1, width: 1 bits </summary>
            public IFlagRegisterField NOTIFY_CRR_REJECTED;
            /// <summary> Field "NOTIFY_IBI_REJECTED" at 0x3, width: 1 bits </summary>
            public IFlagRegisterField NOTIFY_IBI_REJECTED;

            public IbiNotifyCtrlType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(88, 0, true)
                    .WithFlag(0, out NOTIFY_HJ_REJECTED, name: "NOTIFY_HJ_REJECTED")
                    .WithFlag(1, out NOTIFY_CRR_REJECTED, name: "NOTIFY_CRR_REJECTED")
                    .WithFlag(3, out NOTIFY_IBI_REJECTED, name: "NOTIFY_IBI_REJECTED");
            }
        }

        public struct IbiDataAbortCtrlType
        {
            /// <summary> Field "MATCH_IBI_ID" at 0x8, width: 8 bits </summary>
            public IValueRegisterField MATCH_IBI_ID;
            /// <summary> Field "AFTER_N_CHUNKS" at 0x10, width: 2 bits </summary>
            public IValueRegisterField AFTER_N_CHUNKS;
            /// <summary> Field "MATCH_STATUS_TYPE" at 0x12, width: 3 bits </summary>
            public IValueRegisterField MATCH_STATUS_TYPE;
            /// <summary> Field "IBI_DATA_ABORT_MON" at 0x1f, width: 1 bits </summary>
            public IFlagRegisterField IBI_DATA_ABORT_MON;

            public IbiDataAbortCtrlType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(92, 0, true)
                    .WithValueField(8, 8, out MATCH_IBI_ID, name: "MATCH_IBI_ID")
                    .WithValueField(16, 2, out AFTER_N_CHUNKS, name: "AFTER_N_CHUNKS")
                    .WithValueField(18, 3, out MATCH_STATUS_TYPE, name: "MATCH_STATUS_TYPE")
                    .WithFlag(31, out IBI_DATA_ABORT_MON, name: "IBI_DATA_ABORT_MON");
            }
        }

        public struct DevCtxBaseLoType
        {
            /// <summary> Field "BASE_LO" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField BASE_LO;

            public DevCtxBaseLoType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(96, 0, true)
                    .WithFlag(0, out BASE_LO, name: "BASE_LO");
            }
        }

        public struct DevCtxBaseHiType
        {
            /// <summary> Field "BASE_HI" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField BASE_HI;

            public DevCtxBaseHiType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(100, 0, true)
                    .WithFlag(0, out BASE_HI, name: "BASE_HI");
            }
        }

        public struct DevCtxSgType
        {
            /// <summary> Field "LIST_SIZE" at 0x0, width: 16 bits </summary>
            public IValueRegisterField LIST_SIZE;
            /// <summary> Field "BLP" at 0x1f, width: 1 bits </summary>
            public IFlagRegisterField BLP;

            public DevCtxSgType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(104, 0, true)
                    .WithValueField(0, 16, out LIST_SIZE, mode: FieldMode.Read, name: "LIST_SIZE")
                    .WithFlag(31, out BLP, mode: FieldMode.Read, name: "BLP");
            }
        }

        public struct CommandPortType
        {
            /// <summary> Field "COMMAND_DATA" at 0x0, width: 32 bits </summary>
            public IValueRegisterField COMMAND_DATA;

            public CommandPortType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(128, 0, true)
                    .WithValueField(0, 32, out COMMAND_DATA, mode: FieldMode.Write, name: "COMMAND_DATA");
            }
        }

        public struct PIOTxRxDataPortType
        {
            public IValueRegisterField DATA;

            public PIOTxRxDataPortType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(136)
                    .WithValueField(0, 32, out DATA, name: "TX_DATA/RX_DATA");
            }
        }

        public struct ResponsePortType
        {
            /// <summary> Field "RESPONSE_DATA" at 0x0, width: 32 bits </summary>
            public IValueRegisterField RESPONSE_DATA;

            public ResponsePortType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(132, 0, true)
                    .WithValueField(0, 32, out RESPONSE_DATA, mode: FieldMode.Read, name: "RESPONSE_DATA");
            }
        }

        public struct TargetTransactionInterfaceTxDataPortType
        {
            /// <summary> Field "TX_DATA" at 0x0, width: 32 bits </summary>
            public IValueRegisterField TX_DATA;

            public TargetTransactionInterfaceTxDataPortType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(488, 0, true)
                    .WithValueField(0, 32, out TX_DATA, mode: FieldMode.Write, name: "TX_DATA");
            }
        }

        public struct TargetTransactionInterfaceRxDataPortType
        {
            /// <summary> Field "RX_DATA" at 0x0, width: 32 bits </summary>
            public IValueRegisterField RX_DATA;

            public TargetTransactionInterfaceRxDataPortType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(480, 0, true)
                    .WithValueField(0, 32, out RX_DATA, mode: FieldMode.Read, name: "RX_DATA");
            }
        }

        public struct PIOIbiPortType
        {
            public IValueRegisterField IBI_DATA;

            public PIOIbiPortType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(140)
                    .WithValueField(0, 32, out IBI_DATA, mode: FieldMode.Read, name: "IBI_DATA");
            }
        }

        public struct TargetTransactionInterfaceIbiPortType
        {
            /// <summary> Field "IBI_DATA" at 0x0, width: 32 bits </summary>
            public IValueRegisterField IBI_DATA;

            public TargetTransactionInterfaceIbiPortType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(492, 0, true)
                    .WithValueField(0, 32, out IBI_DATA, mode: FieldMode.Write, name: "IBI_DATA");
            }
        }

        public struct PIOQueueThldCtrlType
        {
            public IValueRegisterField CMD_EMPTY_BUF_THLD;
            public IValueRegisterField RESP_BUF_THLD;
            public IValueRegisterField IBI_DATA_SEGMENT_SIZE;
            public IValueRegisterField IBI_STATUS_THLD;

            public PIOQueueThldCtrlType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(144, 16843009)
                    .WithValueField(0, 8, out CMD_EMPTY_BUF_THLD, name: "CMD_EMPTY_BUF_THLD")
                    .WithValueField(8, 8, out RESP_BUF_THLD, name: "RESP_BUF_THLD")
                    .WithValueField(16, 8, out IBI_DATA_SEGMENT_SIZE, name: "IBI_DATA_SEGMENT_SIZE")
                    .WithValueField(24, 8, out IBI_STATUS_THLD, name: "IBI_STATUS_THLD");
            }
        }

        public struct TargetTransactionInterfaceQueueThldCtrlType
        {
            /// <summary> Field "TX_DESC_THLD" at 0x0, width: 8 bits </summary>
            public IValueRegisterField TX_DESC_THLD;
            /// <summary> Field "RX_DESC_THLD" at 0x8, width: 8 bits </summary>
            public IValueRegisterField RX_DESC_THLD;
            /// <summary> Field "IBI_THLD" at 0x18, width: 8 bits </summary>
            public IValueRegisterField IBI_THLD;

            public TargetTransactionInterfaceQueueThldCtrlType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(504, 4278255615, true)
                    .WithValueField(0, 8, out TX_DESC_THLD, name: "TX_DESC_THLD")
                    .WithValueField(8, 8, out RX_DESC_THLD, name: "RX_DESC_THLD")
                    .WithValueField(24, 8, out IBI_THLD, name: "IBI_THLD");
            }
        }

        public struct PIODataBufferThldCtrlType
        {
            public IValueRegisterField TX_BUF_THLD;
            public IValueRegisterField RX_BUF_THLD;
            public IValueRegisterField TX_START_THLD;
            public IValueRegisterField RX_START_THLD;

            public PIODataBufferThldCtrlType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(148, 16843009)
                    .WithValueField(0, 3, out TX_BUF_THLD, name: "TX_BUF_THLD")
                    .WithValueField(8, 3, out RX_BUF_THLD, name: "TX_BUF_THLD")
                    .WithValueField(16, 3, out TX_START_THLD, name: "TX_START_THLD")
                    .WithValueField(24, 3, out RX_START_THLD, name: "RX_START_THLD");
            }
        }

        public struct TargetTransactionInterfaceDataBufferThldCtrlType
        {
            /// <summary> Field "TX_DATA_THLD" at 0x0, width: 3 bits </summary>
            public IValueRegisterField TX_DATA_THLD;
            /// <summary> Field "RX_DATA_THLD" at 0x8, width: 3 bits </summary>
            public IValueRegisterField RX_DATA_THLD;
            /// <summary> Field "TX_START_THLD" at 0x10, width: 3 bits </summary>
            public IValueRegisterField TX_START_THLD;
            /// <summary> Field "RX_START_THLD" at 0x18, width: 3 bits </summary>
            public IValueRegisterField RX_START_THLD;

            public TargetTransactionInterfaceDataBufferThldCtrlType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(508, 117901063, true)
                    .WithValueField(0, 3, out TX_DATA_THLD, name: "TX_DATA_THLD")
                    .WithValueField(8, 3, out RX_DATA_THLD, name: "RX_DATA_THLD")
                    .WithValueField(16, 3, out TX_START_THLD, name: "TX_START_THLD")
                    .WithValueField(24, 3, out RX_START_THLD, name: "RX_START_THLD");
            }
        }

        public struct PIOQueueSizeType
        {
            public IValueRegisterField CR_QUEUE_SIZE;
            public IValueRegisterField IBI_STATUS_SIZE;
            public IValueRegisterField RX_DATA_BUFFER_SIZE;
            public IValueRegisterField TX_DATA_BUFFER_SIZE;

            public PIOQueueSizeType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(152)
                    .WithValueField(0, 8, out CR_QUEUE_SIZE, mode: FieldMode.Read, name: "CR_QUEUE_SIZE")
                    .WithValueField(8, 8, out IBI_STATUS_SIZE, mode: FieldMode.Read, name: "IBI_STATUS_SIZE")
                    .WithValueField(16, 8, out RX_DATA_BUFFER_SIZE, mode: FieldMode.Read, name: "RX_DATA_BUFFER_SIZE")
                    .WithValueField(24, 8, out TX_DATA_BUFFER_SIZE, mode: FieldMode.Read, name: "TX_DATA_BUFFER_SIZE");
            }
        }

        public struct TargetTransactionInterfaceQueueSizeType
        {
            /// <summary> Field "RX_DESC_BUFFER_SIZE" at 0x0, width: 8 bits </summary>
            public IValueRegisterField RX_DESC_BUFFER_SIZE;
            /// <summary> Field "TX_DESC_BUFFER_SIZE" at 0x8, width: 8 bits </summary>
            public IValueRegisterField TX_DESC_BUFFER_SIZE;
            /// <summary> Field "RX_DATA_BUFFER_SIZE" at 0x10, width: 8 bits </summary>
            public IValueRegisterField RX_DATA_BUFFER_SIZE;
            /// <summary> Field "TX_DATA_BUFFER_SIZE" at 0x18, width: 8 bits </summary>
            public IValueRegisterField TX_DATA_BUFFER_SIZE;

            public TargetTransactionInterfaceQueueSizeType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(496, 4294967295, true)
                    .WithValueField(0, 8, out RX_DESC_BUFFER_SIZE, mode: FieldMode.Read, name: "RX_DESC_BUFFER_SIZE")
                    .WithValueField(8, 8, out TX_DESC_BUFFER_SIZE, mode: FieldMode.Read, name: "TX_DESC_BUFFER_SIZE")
                    .WithValueField(16, 8, out RX_DATA_BUFFER_SIZE, mode: FieldMode.Read, name: "RX_DATA_BUFFER_SIZE")
                    .WithValueField(24, 8, out TX_DATA_BUFFER_SIZE, mode: FieldMode.Read, name: "TX_DATA_BUFFER_SIZE");
            }
        }

        public struct AltQueueSizeType
        {
            /// <summary> Field "ALT_RESP_QUEUE_SIZE" at 0x0, width: 8 bits </summary>
            public IValueRegisterField ALT_RESP_QUEUE_SIZE;
            /// <summary> Field "ALT_RESP_QUEUE_EN" at 0x18, width: 1 bits </summary>
            public IFlagRegisterField ALT_RESP_QUEUE_EN;
            /// <summary> Field "EXT_IBI_QUEUE_EN" at 0x1c, width: 1 bits </summary>
            public IFlagRegisterField EXT_IBI_QUEUE_EN;

            public AltQueueSizeType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(156, 16777471, true)
                    .WithValueField(0, 8, out ALT_RESP_QUEUE_SIZE, mode: FieldMode.Read, name: "ALT_RESP_QUEUE_SIZE")
                    .WithFlag(24, out ALT_RESP_QUEUE_EN, mode: FieldMode.Read, name: "ALT_RESP_QUEUE_EN")
                    .WithFlag(28, out EXT_IBI_QUEUE_EN, mode: FieldMode.Read, name: "EXT_IBI_QUEUE_EN");
            }
        }

        public struct PioIntrStatusType
        {
            /// <summary> Field "TX_THLD_STAT" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField TX_THLD_STAT;
            /// <summary> Field "RX_THLD_STAT" at 0x1, width: 1 bits </summary>
            public IFlagRegisterField RX_THLD_STAT;
            /// <summary> Field "IBI_STATUS_THLD_STAT" at 0x2, width: 1 bits </summary>
            public IFlagRegisterField IBI_STATUS_THLD_STAT;
            /// <summary> Field "CMD_QUEUE_READY_STAT" at 0x3, width: 1 bits </summary>
            public IFlagRegisterField CMD_QUEUE_READY_STAT;
            /// <summary> Field "RESP_READY_STAT" at 0x4, width: 1 bits </summary>
            public IFlagRegisterField RESP_READY_STAT;
            /// <summary> Field "TRANSFER_ABORT_STAT" at 0x5, width: 1 bits </summary>
            public IFlagRegisterField TRANSFER_ABORT_STAT;
            /// <summary> Field "TRANSFER_ERR_STAT" at 0x9, width: 1 bits </summary>
            public IFlagRegisterField TRANSFER_ERR_STAT;

            public PioIntrStatusType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(160, 0, true)
                    .WithFlag(0, out TX_THLD_STAT, mode: FieldMode.Read, name: "TX_THLD_STAT")
                    .WithFlag(1, out RX_THLD_STAT, mode: FieldMode.Read, name: "RX_THLD_STAT")
                    .WithFlag(2, out IBI_STATUS_THLD_STAT, mode: FieldMode.Read, name: "IBI_STATUS_THLD_STAT")
                    .WithFlag(3, out CMD_QUEUE_READY_STAT, mode: FieldMode.Read, name: "CMD_QUEUE_READY_STAT")
                    .WithFlag(4, out RESP_READY_STAT, mode: FieldMode.Read, name: "RESP_READY_STAT")
                    .WithFlag(5, out TRANSFER_ABORT_STAT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "TRANSFER_ABORT_STAT")
                    .WithFlag(9, out TRANSFER_ERR_STAT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "TRANSFER_ERR_STAT");
            }
        }

        public struct PioIntrStatusEnableType
        {
            /// <summary> Field "TX_THLD_STAT_EN" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField TX_THLD_STAT_EN;
            /// <summary> Field "RX_THLD_STAT_EN" at 0x1, width: 1 bits </summary>
            public IFlagRegisterField RX_THLD_STAT_EN;
            /// <summary> Field "IBI_STATUS_THLD_STAT_EN" at 0x2, width: 1 bits </summary>
            public IFlagRegisterField IBI_STATUS_THLD_STAT_EN;
            /// <summary> Field "CMD_QUEUE_READY_STAT_EN" at 0x3, width: 1 bits </summary>
            public IFlagRegisterField CMD_QUEUE_READY_STAT_EN;
            /// <summary> Field "RESP_READY_STAT_EN" at 0x4, width: 1 bits </summary>
            public IFlagRegisterField RESP_READY_STAT_EN;
            /// <summary> Field "TRANSFER_ABORT_STAT_EN" at 0x5, width: 1 bits </summary>
            public IFlagRegisterField TRANSFER_ABORT_STAT_EN;
            /// <summary> Field "TRANSFER_ERR_STAT_EN" at 0x9, width: 1 bits </summary>
            public IFlagRegisterField TRANSFER_ERR_STAT_EN;

            public PioIntrStatusEnableType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(164, 0, true)
                    .WithFlag(0, out TX_THLD_STAT_EN, name: "TX_THLD_STAT_EN")
                    .WithFlag(1, out RX_THLD_STAT_EN, name: "RX_THLD_STAT_EN")
                    .WithFlag(2, out IBI_STATUS_THLD_STAT_EN, name: "IBI_STATUS_THLD_STAT_EN")
                    .WithFlag(3, out CMD_QUEUE_READY_STAT_EN, name: "CMD_QUEUE_READY_STAT_EN")
                    .WithFlag(4, out RESP_READY_STAT_EN, name: "RESP_READY_STAT_EN")
                    .WithFlag(5, out TRANSFER_ABORT_STAT_EN, name: "TRANSFER_ABORT_STAT_EN")
                    .WithFlag(9, out TRANSFER_ERR_STAT_EN, name: "TRANSFER_ERR_STAT_EN");
            }
        }

        public struct PioIntrSignalEnableType
        {
            /// <summary> Field "TX_THLD_SIGNAL_EN" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField TX_THLD_SIGNAL_EN;
            /// <summary> Field "RX_THLD_SIGNAL_EN" at 0x1, width: 1 bits </summary>
            public IFlagRegisterField RX_THLD_SIGNAL_EN;
            /// <summary> Field "IBI_STATUS_THLD_SIGNAL_EN" at 0x2, width: 1 bits </summary>
            public IFlagRegisterField IBI_STATUS_THLD_SIGNAL_EN;
            /// <summary> Field "CMD_QUEUE_READY_SIGNAL_EN" at 0x3, width: 1 bits </summary>
            public IFlagRegisterField CMD_QUEUE_READY_SIGNAL_EN;
            /// <summary> Field "RESP_READY_SIGNAL_EN" at 0x4, width: 1 bits </summary>
            public IFlagRegisterField RESP_READY_SIGNAL_EN;
            /// <summary> Field "TRANSFER_ABORT_SIGNAL_EN" at 0x5, width: 1 bits </summary>
            public IFlagRegisterField TRANSFER_ABORT_SIGNAL_EN;
            /// <summary> Field "TRANSFER_ERR_SIGNAL_EN" at 0x9, width: 1 bits </summary>
            public IFlagRegisterField TRANSFER_ERR_SIGNAL_EN;

            public PioIntrSignalEnableType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(168, 0, true)
                    .WithFlag(0, out TX_THLD_SIGNAL_EN, name: "TX_THLD_SIGNAL_EN")
                    .WithFlag(1, out RX_THLD_SIGNAL_EN, name: "RX_THLD_SIGNAL_EN")
                    .WithFlag(2, out IBI_STATUS_THLD_SIGNAL_EN, name: "IBI_STATUS_THLD_SIGNAL_EN")
                    .WithFlag(3, out CMD_QUEUE_READY_SIGNAL_EN, name: "CMD_QUEUE_READY_SIGNAL_EN")
                    .WithFlag(4, out RESP_READY_SIGNAL_EN, name: "RESP_READY_SIGNAL_EN")
                    .WithFlag(5, out TRANSFER_ABORT_SIGNAL_EN, name: "TRANSFER_ABORT_SIGNAL_EN")
                    .WithFlag(9, out TRANSFER_ERR_SIGNAL_EN, name: "TRANSFER_ERR_SIGNAL_EN");
            }
        }

        public struct PioIntrForceType
        {
            /// <summary> Field "TX_THLD_FORCE" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField TX_THLD_FORCE;
            /// <summary> Field "RX_THLD_FORCE" at 0x1, width: 1 bits </summary>
            public IFlagRegisterField RX_THLD_FORCE;
            /// <summary> Field "IBI_THLD_FORCE" at 0x2, width: 1 bits </summary>
            public IFlagRegisterField IBI_THLD_FORCE;
            /// <summary> Field "CMD_QUEUE_READY_FORCE" at 0x3, width: 1 bits </summary>
            public IFlagRegisterField CMD_QUEUE_READY_FORCE;
            /// <summary> Field "RESP_READY_FORCE" at 0x4, width: 1 bits </summary>
            public IFlagRegisterField RESP_READY_FORCE;
            /// <summary> Field "TRANSFER_ABORT_FORCE" at 0x5, width: 1 bits </summary>
            public IFlagRegisterField TRANSFER_ABORT_FORCE;
            /// <summary> Field "TRANSFER_ERR_FORCE" at 0x9, width: 1 bits </summary>
            public IFlagRegisterField TRANSFER_ERR_FORCE;

            public PioIntrForceType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(172, 0, true)
                    .WithFlag(0, out TX_THLD_FORCE, mode: FieldMode.Write, name: "TX_THLD_FORCE")
                    .WithFlag(1, out RX_THLD_FORCE, mode: FieldMode.Write, name: "RX_THLD_FORCE")
                    .WithFlag(2, out IBI_THLD_FORCE, mode: FieldMode.Write, name: "IBI_THLD_FORCE")
                    .WithFlag(3, out CMD_QUEUE_READY_FORCE, mode: FieldMode.Write, name: "CMD_QUEUE_READY_FORCE")
                    .WithFlag(4, out RESP_READY_FORCE, mode: FieldMode.Write, name: "RESP_READY_FORCE")
                    .WithFlag(5, out TRANSFER_ABORT_FORCE, mode: FieldMode.Write, name: "TRANSFER_ABORT_FORCE")
                    .WithFlag(9, out TRANSFER_ERR_FORCE, mode: FieldMode.Write, name: "TRANSFER_ERR_FORCE");
            }
        }

        public struct PioControlType
        {
            /// <summary> Field "ENABLE" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField ENABLE;
            /// <summary> Field "RS" at 0x1, width: 1 bits </summary>
            public IFlagRegisterField RS;
            /// <summary> Field "ABORT" at 0x2, width: 1 bits </summary>
            public IFlagRegisterField ABORT;

            public PioControlType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(176, 1, true)
                    .WithFlag(0, out ENABLE, name: "ENABLE")
                    .WithFlag(1, out RS, name: "RS")
                    .WithFlag(2, out ABORT, name: "ABORT");
            }
        }

        public struct SecureFirmwareRecoveryInterfaceExtcapHeaderType
        {
            /// <summary> Field "CAP_ID" at 0x0, width: 8 bits </summary>
            public IValueRegisterField CAP_ID;
            /// <summary> Field "CAP_LENGTH" at 0x8, width: 16 bits </summary>
            public IValueRegisterField CAP_LENGTH;

            public SecureFirmwareRecoveryInterfaceExtcapHeaderType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(256, 8384, true)
                    .WithValueField(0, 8, out CAP_ID, mode: FieldMode.Read, name: "CAP_ID")
                    .WithValueField(8, 16, out CAP_LENGTH, mode: FieldMode.Read, name: "CAP_LENGTH");
            }
        }

        public struct StandbyControllerModeRegistersExtcapHeaderType
        {
            /// <summary> Field "CAP_ID" at 0x0, width: 8 bits </summary>
            public IValueRegisterField CAP_ID;
            /// <summary> Field "CAP_LENGTH" at 0x8, width: 16 bits </summary>
            public IValueRegisterField CAP_LENGTH;

            public StandbyControllerModeRegistersExtcapHeaderType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(384, 4114, true)
                    .WithValueField(0, 8, out CAP_ID, mode: FieldMode.Read, name: "CAP_ID")
                    .WithValueField(8, 16, out CAP_LENGTH, mode: FieldMode.Read, name: "CAP_LENGTH");
            }
        }

        public struct SoCManagementInterfaceRegistersExtcapHeaderType
        {
            /// <summary> Field "CAP_ID" at 0x0, width: 8 bits </summary>
            public IValueRegisterField CAP_ID;
            /// <summary> Field "CAP_LENGTH" at 0x8, width: 16 bits </summary>
            public IValueRegisterField CAP_LENGTH;

            public SoCManagementInterfaceRegistersExtcapHeaderType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(512, 6337, true)
                    .WithValueField(0, 8, out CAP_ID, mode: FieldMode.Read, name: "CAP_ID")
                    .WithValueField(8, 16, out CAP_LENGTH, mode: FieldMode.Read, name: "CAP_LENGTH");
            }
        }

        public struct TargetTransactionInterfaceRegistersExtcapHeaderType
        {
            /// <summary> Field "CAP_ID" at 0x0, width: 8 bits </summary>
            public IValueRegisterField CAP_ID;
            /// <summary> Field "CAP_LENGTH" at 0x8, width: 16 bits </summary>
            public IValueRegisterField CAP_LENGTH;

            public TargetTransactionInterfaceRegistersExtcapHeaderType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(448, 4292, true)
                    .WithValueField(0, 8, out CAP_ID, mode: FieldMode.Read, name: "CAP_ID")
                    .WithValueField(8, 16, out CAP_LENGTH, mode: FieldMode.Read, name: "CAP_LENGTH");
            }
        }

        public struct ControllerConfigRegistersExtcapHeaderType
        {
            /// <summary> Field "CAP_ID" at 0x0, width: 8 bits </summary>
            public IValueRegisterField CAP_ID;
            /// <summary> Field "CAP_LENGTH" at 0x8, width: 16 bits </summary>
            public IValueRegisterField CAP_LENGTH;

            public ControllerConfigRegistersExtcapHeaderType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(608, 514, true)
                    .WithValueField(0, 8, out CAP_ID, mode: FieldMode.Read, name: "CAP_ID")
                    .WithValueField(8, 16, out CAP_LENGTH, mode: FieldMode.Read, name: "CAP_LENGTH");
            }
        }

        public struct ProtCap0Type
        {
            /// <summary> Field "REC_MAGIC_STRING_0" at 0x0, width: 32 bits </summary>
            public IValueRegisterField REC_MAGIC_STRING_0;

            public ProtCap0Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(260, 4294967295, true)
                    .WithValueField(0, 32, out REC_MAGIC_STRING_0, mode: FieldMode.Read, name: "REC_MAGIC_STRING_0");
            }
        }

        public struct ProtCap1Type
        {
            /// <summary> Field "REC_MAGIC_STRING_1" at 0x0, width: 32 bits </summary>
            public IValueRegisterField REC_MAGIC_STRING_1;

            public ProtCap1Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(264, 4294967295, true)
                    .WithValueField(0, 32, out REC_MAGIC_STRING_1, mode: FieldMode.Read, name: "REC_MAGIC_STRING_1");
            }
        }

        public struct ProtCap2Type
        {
            /// <summary> Field "REC_PROT_VERSION" at 0x0, width: 16 bits </summary>
            public IValueRegisterField REC_PROT_VERSION;
            /// <summary> Field "AGENT_CAPS" at 0x10, width: 16 bits </summary>
            public IValueRegisterField AGENT_CAPS;

            public ProtCap2Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(268, 0, true)
                    .WithValueField(0, 16, out REC_PROT_VERSION, name: "REC_PROT_VERSION")
                    .WithValueField(16, 16, out AGENT_CAPS, name: "AGENT_CAPS");
            }
        }

        public struct ProtCap3Type
        {
            /// <summary> Field "NUM_OF_CMS_REGIONS" at 0x0, width: 8 bits </summary>
            public IValueRegisterField NUM_OF_CMS_REGIONS;
            /// <summary> Field "MAX_RESP_TIME" at 0x8, width: 8 bits </summary>
            public IValueRegisterField MAX_RESP_TIME;
            /// <summary> Field "HEARTBEAT_PERIOD" at 0x10, width: 8 bits </summary>
            public IValueRegisterField HEARTBEAT_PERIOD;

            public ProtCap3Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(272, 0, true)
                    .WithValueField(0, 8, out NUM_OF_CMS_REGIONS, name: "NUM_OF_CMS_REGIONS")
                    .WithValueField(8, 8, out MAX_RESP_TIME, name: "MAX_RESP_TIME")
                    .WithValueField(16, 8, out HEARTBEAT_PERIOD, name: "HEARTBEAT_PERIOD");
            }
        }

        public struct DeviceId0Type
        {
            /// <summary> Field "DESC_TYPE" at 0x0, width: 8 bits </summary>
            public IValueRegisterField DESC_TYPE;
            /// <summary> Field "VENDOR_SPECIFIC_STR_LENGTH" at 0x8, width: 8 bits </summary>
            public IValueRegisterField VENDOR_SPECIFIC_STR_LENGTH;
            /// <summary> Field "DATA" at 0x10, width: 16 bits </summary>
            public IValueRegisterField DATA;

            public DeviceId0Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(276, 0, true)
                    .WithValueField(0, 8, out DESC_TYPE, name: "DESC_TYPE")
                    .WithValueField(8, 8, out VENDOR_SPECIFIC_STR_LENGTH, name: "VENDOR_SPECIFIC_STR_LENGTH")
                    .WithValueField(16, 16, out DATA, name: "DATA");
            }
        }

        public struct DeviceId1Type
        {
            /// <summary> Field "DATA" at 0x0, width: 32 bits </summary>
            public IValueRegisterField DATA;

            public DeviceId1Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(280, 0, true)
                    .WithValueField(0, 32, out DATA, name: "DATA");
            }
        }

        public struct DeviceId2Type
        {
            /// <summary> Field "DATA" at 0x0, width: 32 bits </summary>
            public IValueRegisterField DATA;

            public DeviceId2Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(284, 0, true)
                    .WithValueField(0, 32, out DATA, name: "DATA");
            }
        }

        public struct DeviceId3Type
        {
            /// <summary> Field "DATA" at 0x0, width: 32 bits </summary>
            public IValueRegisterField DATA;

            public DeviceId3Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(288, 0, true)
                    .WithValueField(0, 32, out DATA, name: "DATA");
            }
        }

        public struct DeviceId4Type
        {
            /// <summary> Field "DATA" at 0x0, width: 32 bits </summary>
            public IValueRegisterField DATA;

            public DeviceId4Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(292, 0, true)
                    .WithValueField(0, 32, out DATA, name: "DATA");
            }
        }

        public struct DeviceId5Type
        {
            /// <summary> Field "DATA" at 0x0, width: 32 bits </summary>
            public IValueRegisterField DATA;

            public DeviceId5Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(296, 0, true)
                    .WithValueField(0, 32, out DATA, name: "DATA");
            }
        }

        public struct DeviceIdReservedType
        {
            /// <summary> Field "DATA" at 0x0, width: 32 bits </summary>
            public IValueRegisterField DATA;

            public DeviceIdReservedType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(300, 0, true)
                    .WithValueField(0, 32, out DATA, mode: FieldMode.Read, name: "DATA");
            }
        }

        public struct DeviceStatus0Type
        {
            /// <summary> Field "DEV_STATUS" at 0x0, width: 8 bits </summary>
            public IValueRegisterField DEV_STATUS;
            /// <summary> Field "PROT_ERROR" at 0x8, width: 8 bits </summary>
            public IValueRegisterField PROT_ERROR;
            /// <summary> Field "REC_REASON_CODE" at 0x10, width: 16 bits </summary>
            public IValueRegisterField REC_REASON_CODE;

            public DeviceStatus0Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(304, 0, true)
                    .WithValueField(0, 8, out DEV_STATUS, name: "DEV_STATUS")
                    .WithValueField(8, 8, out PROT_ERROR, mode: FieldMode.ReadToClear | FieldMode.Write, name: "PROT_ERROR")
                    .WithValueField(16, 16, out REC_REASON_CODE, name: "REC_REASON_CODE");
            }
        }

        public struct DeviceStatus1Type
        {
            /// <summary> Field "HEARTBEAT" at 0x0, width: 16 bits </summary>
            public IValueRegisterField HEARTBEAT;
            /// <summary> Field "VENDOR_STATUS_LENGTH" at 0x10, width: 9 bits </summary>
            public IValueRegisterField VENDOR_STATUS_LENGTH;
            /// <summary> Field "VENDOR_STATUS" at 0x19, width: 7 bits </summary>
            public IValueRegisterField VENDOR_STATUS;

            public DeviceStatus1Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(308, 0, true)
                    .WithValueField(0, 16, out HEARTBEAT, name: "HEARTBEAT")
                    .WithValueField(16, 9, out VENDOR_STATUS_LENGTH, name: "VENDOR_STATUS_LENGTH")
                    .WithValueField(25, 7, out VENDOR_STATUS, name: "VENDOR_STATUS");
            }
        }

        public struct DeviceResetType
        {
            /// <summary> Field "RESET_CTRL" at 0x0, width: 8 bits </summary>
            public IValueRegisterField RESET_CTRL;
            /// <summary> Field "FORCED_RECOVERY" at 0x8, width: 8 bits </summary>
            public IValueRegisterField FORCED_RECOVERY;
            /// <summary> Field "IF_CTRL" at 0x10, width: 8 bits </summary>
            public IValueRegisterField IF_CTRL;

            public DeviceResetType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(312, 0, true)
                    .WithValueField(0, 8, out RESET_CTRL, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "RESET_CTRL")
                    .WithValueField(8, 8, out FORCED_RECOVERY, name: "FORCED_RECOVERY")
                    .WithValueField(16, 8, out IF_CTRL, name: "IF_CTRL");
            }
        }

        public struct RecoveryCtrlType
        {
            /// <summary> Field "CMS" at 0x0, width: 8 bits </summary>
            public IValueRegisterField CMS;
            /// <summary> Field "REC_IMG_SEL" at 0x8, width: 8 bits </summary>
            public IValueRegisterField REC_IMG_SEL;
            /// <summary> Field "ACTIVATE_REC_IMG" at 0x10, width: 8 bits </summary>
            public IValueRegisterField ACTIVATE_REC_IMG;

            public RecoveryCtrlType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(316, 0, true)
                    .WithValueField(0, 8, out CMS, name: "CMS")
                    .WithValueField(8, 8, out REC_IMG_SEL, name: "REC_IMG_SEL")
                    .WithValueField(16, 8, out ACTIVATE_REC_IMG, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "ACTIVATE_REC_IMG");
            }
        }

        public struct RecoveryStatusType
        {
            /// <summary> Field "DEV_REC_STATUS" at 0x0, width: 4 bits </summary>
            public IValueRegisterField DEV_REC_STATUS;
            /// <summary> Field "REC_IMG_INDEX" at 0x4, width: 4 bits </summary>
            public IValueRegisterField REC_IMG_INDEX;
            /// <summary> Field "VENDOR_SPECIFIC_STATUS" at 0x8, width: 8 bits </summary>
            public IValueRegisterField VENDOR_SPECIFIC_STATUS;

            public RecoveryStatusType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(320, 0, true)
                    .WithValueField(0, 4, out DEV_REC_STATUS, name: "DEV_REC_STATUS")
                    .WithValueField(4, 4, out REC_IMG_INDEX, name: "REC_IMG_INDEX")
                    .WithValueField(8, 8, out VENDOR_SPECIFIC_STATUS, name: "VENDOR_SPECIFIC_STATUS");
            }
        }

        public struct HwStatusType
        {
            /// <summary> Field "TEMP_CRITICAL" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField TEMP_CRITICAL;
            /// <summary> Field "SOFT_ERR" at 0x1, width: 1 bits </summary>
            public IFlagRegisterField SOFT_ERR;
            /// <summary> Field "FATAL_ERR" at 0x2, width: 1 bits </summary>
            public IFlagRegisterField FATAL_ERR;
            /// <summary> Field "RESERVED_7_3" at 0x3, width: 5 bits </summary>
            public IValueRegisterField RESERVED_7_3;
            /// <summary> Field "VENDOR_HW_STATUS" at 0x8, width: 8 bits </summary>
            public IValueRegisterField VENDOR_HW_STATUS;
            /// <summary> Field "CTEMP" at 0x10, width: 8 bits </summary>
            public IValueRegisterField CTEMP;
            /// <summary> Field "VENDOR_HW_STATUS_LEN" at 0x18, width: 8 bits </summary>
            public IValueRegisterField VENDOR_HW_STATUS_LEN;

            public HwStatusType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(324, 0, true)
                    .WithFlag(0, out TEMP_CRITICAL, name: "TEMP_CRITICAL")
                    .WithFlag(1, out SOFT_ERR, name: "SOFT_ERR")
                    .WithFlag(2, out FATAL_ERR, name: "FATAL_ERR")
                    .WithValueField(3, 5, out RESERVED_7_3, name: "RESERVED_7_3")
                    .WithValueField(8, 8, out VENDOR_HW_STATUS, name: "VENDOR_HW_STATUS")
                    .WithValueField(16, 8, out CTEMP, name: "CTEMP")
                    .WithValueField(24, 8, out VENDOR_HW_STATUS_LEN, name: "VENDOR_HW_STATUS_LEN");
            }
        }

        public struct IndirectFifoCtrl0Type
        {
            /// <summary> Field "CMS" at 0x0, width: 8 bits </summary>
            public IValueRegisterField CMS;
            /// <summary> Field "RESET" at 0x8, width: 8 bits </summary>
            public IValueRegisterField RESET;

            public IndirectFifoCtrl0Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(328, 0, true)
                    .WithValueField(0, 8, out CMS, name: "CMS")
                    .WithValueField(8, 8, out RESET, name: "RESET");
            }
        }

        public struct IndirectFifoCtrl1Type
        {
            /// <summary> Field "IMAGE_SIZE" at 0x0, width: 32 bits </summary>
            public IValueRegisterField IMAGE_SIZE;

            public IndirectFifoCtrl1Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(332, 0, true)
                    .WithValueField(0, 32, out IMAGE_SIZE, name: "IMAGE_SIZE");
            }
        }

        public struct IndirectFifoStatus0Type
        {
            /// <summary> Field "EMPTY" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField EMPTY;
            /// <summary> Field "FULL" at 0x1, width: 1 bits </summary>
            public IFlagRegisterField FULL;
            /// <summary> Field "REGION_TYPE" at 0x8, width: 3 bits </summary>
            public IValueRegisterField REGION_TYPE;

            public IndirectFifoStatus0Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(336, 1, true)
                    .WithFlag(0, out EMPTY, mode: FieldMode.Read, name: "EMPTY")
                    .WithFlag(1, out FULL, mode: FieldMode.Read, name: "FULL")
                    .WithValueField(8, 3, out REGION_TYPE, mode: FieldMode.Read, name: "REGION_TYPE");
            }
        }

        public struct IndirectFifoStatus1Type
        {
            /// <summary> Field "WRITE_INDEX" at 0x0, width: 32 bits </summary>
            public IValueRegisterField WRITE_INDEX;

            public IndirectFifoStatus1Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(340, 0, true)
                    .WithValueField(0, 32, out WRITE_INDEX, mode: FieldMode.Read, name: "WRITE_INDEX");
            }
        }

        public struct IndirectFifoStatus2Type
        {
            /// <summary> Field "READ_INDEX" at 0x0, width: 32 bits </summary>
            public IValueRegisterField READ_INDEX;

            public IndirectFifoStatus2Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(344, 0, true)
                    .WithValueField(0, 32, out READ_INDEX, mode: FieldMode.Read, name: "READ_INDEX");
            }
        }

        public struct IndirectFifoStatus3Type
        {
            /// <summary> Field "FIFO_SIZE" at 0x0, width: 32 bits </summary>
            public IValueRegisterField FIFO_SIZE;

            public IndirectFifoStatus3Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(348, 4294967295, true)
                    .WithValueField(0, 32, out FIFO_SIZE, mode: FieldMode.Read, name: "FIFO_SIZE");
            }
        }

        public struct IndirectFifoStatus4Type
        {
            /// <summary> Field "MAX_TRANSFER_SIZE" at 0x0, width: 32 bits </summary>
            public IValueRegisterField MAX_TRANSFER_SIZE;

            public IndirectFifoStatus4Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(352, 0, true)
                    .WithValueField(0, 32, out MAX_TRANSFER_SIZE, mode: FieldMode.Read, name: "MAX_TRANSFER_SIZE");
            }
        }

        public struct IndirectFifoReservedType
        {
            /// <summary> Field "DATA" at 0x0, width: 32 bits </summary>
            public IValueRegisterField DATA;

            public IndirectFifoReservedType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(356, 0, true)
                    .WithValueField(0, 32, out DATA, mode: FieldMode.Read, name: "DATA");
            }
        }

        public struct IndirectFifoDataType
        {
            /// <summary> Field "DATA" at 0x0, width: 32 bits </summary>
            public IValueRegisterField DATA;

            public IndirectFifoDataType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(360, 0, true)
                    .WithValueField(0, 32, out DATA, name: "DATA");
            }
        }

        public struct StbyCrControlType
        {
            /// <summary> Field "PENDING_RX_NACK" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField PENDING_RX_NACK;
            /// <summary> Field "HANDOFF_DELAY_NACK" at 0x1, width: 1 bits </summary>
            public IFlagRegisterField HANDOFF_DELAY_NACK;
            /// <summary> Field "ACR_FSM_OP_SELECT" at 0x2, width: 1 bits </summary>
            public IFlagRegisterField ACR_FSM_OP_SELECT;
            /// <summary> Field "PRIME_ACCEPT_GETACCCR" at 0x3, width: 1 bits </summary>
            public IFlagRegisterField PRIME_ACCEPT_GETACCCR;
            /// <summary> Field "HANDOFF_DEEP_SLEEP" at 0x4, width: 1 bits </summary>
            public IFlagRegisterField HANDOFF_DEEP_SLEEP;
            /// <summary> Field "CR_REQUEST_SEND" at 0x5, width: 1 bits </summary>
            public IFlagRegisterField CR_REQUEST_SEND;
            /// <summary> Field "BAST_CCC_IBI_RING" at 0x8, width: 3 bits </summary>
            public IValueRegisterField BAST_CCC_IBI_RING;
            /// <summary> Field "TARGET_XACT_ENABLE" at 0xc, width: 1 bits </summary>
            public IFlagRegisterField TARGET_XACT_ENABLE;
            /// <summary> Field "DAA_SETAASA_ENABLE" at 0xd, width: 1 bits </summary>
            public IFlagRegisterField DAA_SETAASA_ENABLE;
            /// <summary> Field "DAA_SETDASA_ENABLE" at 0xe, width: 1 bits </summary>
            public IFlagRegisterField DAA_SETDASA_ENABLE;
            /// <summary> Field "DAA_ENTDAA_ENABLE" at 0xf, width: 1 bits </summary>
            public IFlagRegisterField DAA_ENTDAA_ENABLE;
            /// <summary> Field "RSTACT_DEFBYTE_02" at 0x14, width: 1 bits </summary>
            public IFlagRegisterField RSTACT_DEFBYTE_02;
            /// <summary> Field "STBY_CR_ENABLE_INIT" at 0x1e, width: 2 bits </summary>
            public IValueRegisterField STBY_CR_ENABLE_INIT;

            public StbyCrControlType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(388, 4096, true)
                    .WithFlag(0, out PENDING_RX_NACK, name: "PENDING_RX_NACK")
                    .WithFlag(1, out HANDOFF_DELAY_NACK, name: "HANDOFF_DELAY_NACK")
                    .WithFlag(2, out ACR_FSM_OP_SELECT, name: "ACR_FSM_OP_SELECT")
                    .WithFlag(3, out PRIME_ACCEPT_GETACCCR, name: "PRIME_ACCEPT_GETACCCR")
                    .WithFlag(4, out HANDOFF_DEEP_SLEEP, mode: FieldMode.Read | FieldMode.Write, name: "HANDOFF_DEEP_SLEEP")
                    .WithFlag(5, out CR_REQUEST_SEND, mode: FieldMode.Write, name: "CR_REQUEST_SEND")
                    .WithValueField(8, 3, out BAST_CCC_IBI_RING, name: "BAST_CCC_IBI_RING")
                    .WithFlag(12, out TARGET_XACT_ENABLE, name: "TARGET_XACT_ENABLE")
                    .WithFlag(13, out DAA_SETAASA_ENABLE, name: "DAA_SETAASA_ENABLE")
                    .WithFlag(14, out DAA_SETDASA_ENABLE, name: "DAA_SETDASA_ENABLE")
                    .WithFlag(15, out DAA_ENTDAA_ENABLE, name: "DAA_ENTDAA_ENABLE")
                    .WithFlag(20, out RSTACT_DEFBYTE_02, name: "RSTACT_DEFBYTE_02")
                    .WithValueField(30, 2, out STBY_CR_ENABLE_INIT, name: "STBY_CR_ENABLE_INIT");
            }
        }

        public struct StbyCrDeviceAddrType
        {
            /// <summary> Field "STATIC_ADDR" at 0x0, width: 7 bits </summary>
            public IValueRegisterField STATIC_ADDR;
            /// <summary> Field "STATIC_ADDR_VALID" at 0xf, width: 1 bits </summary>
            public IFlagRegisterField STATIC_ADDR_VALID;
            /// <summary> Field "DYNAMIC_ADDR" at 0x10, width: 7 bits </summary>
            public IValueRegisterField DYNAMIC_ADDR;
            /// <summary> Field "DYNAMIC_ADDR_VALID" at 0x1f, width: 1 bits </summary>
            public IFlagRegisterField DYNAMIC_ADDR_VALID;

            public StbyCrDeviceAddrType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(392, 0, true)
                    .WithValueField(0, 7, out STATIC_ADDR, name: "STATIC_ADDR")
                    .WithFlag(15, out STATIC_ADDR_VALID, name: "STATIC_ADDR_VALID")
                    .WithValueField(16, 7, out DYNAMIC_ADDR, name: "DYNAMIC_ADDR")
                    .WithFlag(31, out DYNAMIC_ADDR_VALID, name: "DYNAMIC_ADDR_VALID");
            }
        }

        public struct StbyCrCapabilitiesType
        {
            /// <summary> Field "SIMPLE_CRR_SUPPORT" at 0x5, width: 1 bits </summary>
            public IFlagRegisterField SIMPLE_CRR_SUPPORT;
            /// <summary> Field "TARGET_XACT_SUPPORT" at 0xc, width: 1 bits </summary>
            public IFlagRegisterField TARGET_XACT_SUPPORT;
            /// <summary> Field "DAA_SETAASA_SUPPORT" at 0xd, width: 1 bits </summary>
            public IFlagRegisterField DAA_SETAASA_SUPPORT;
            /// <summary> Field "DAA_SETDASA_SUPPORT" at 0xe, width: 1 bits </summary>
            public IFlagRegisterField DAA_SETDASA_SUPPORT;
            /// <summary> Field "DAA_ENTDAA_SUPPORT" at 0xf, width: 1 bits </summary>
            public IFlagRegisterField DAA_ENTDAA_SUPPORT;

            public StbyCrCapabilitiesType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(396, 28672, true)
                    .WithFlag(5, out SIMPLE_CRR_SUPPORT, mode: FieldMode.Read, name: "SIMPLE_CRR_SUPPORT")
                    .WithFlag(12, out TARGET_XACT_SUPPORT, mode: FieldMode.Read, name: "TARGET_XACT_SUPPORT")
                    .WithFlag(13, out DAA_SETAASA_SUPPORT, mode: FieldMode.Read, name: "DAA_SETAASA_SUPPORT")
                    .WithFlag(14, out DAA_SETDASA_SUPPORT, mode: FieldMode.Read, name: "DAA_SETDASA_SUPPORT")
                    .WithFlag(15, out DAA_ENTDAA_SUPPORT, mode: FieldMode.Read, name: "DAA_ENTDAA_SUPPORT");
            }
        }

        public struct Rsvd0Type
        {
            /// <summary> Field "__rsvd" at 0x0, width: 32 bits </summary>
            public IValueRegisterField __RSVD;

            public Rsvd0Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(400, 0, true)
                    .WithValueField(0, 32, out __RSVD, name: "__RSVD");
            }
        }

        public struct StbyCrStatusType
        {
            /// <summary> Field "AC_CURRENT_OWN" at 0x2, width: 1 bits </summary>
            public IFlagRegisterField AC_CURRENT_OWN;
            /// <summary> Field "SIMPLE_CRR_STATUS" at 0x5, width: 3 bits </summary>
            public IValueRegisterField SIMPLE_CRR_STATUS;
            /// <summary> Field "HJ_REQ_STATUS" at 0x8, width: 1 bits </summary>
            public IFlagRegisterField HJ_REQ_STATUS;

            public StbyCrStatusType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(404, 0, true)
                    .WithFlag(2, out AC_CURRENT_OWN, name: "AC_CURRENT_OWN")
                    .WithValueField(5, 3, out SIMPLE_CRR_STATUS, name: "SIMPLE_CRR_STATUS")
                    .WithFlag(8, out HJ_REQ_STATUS, name: "HJ_REQ_STATUS");
            }
        }

        public struct StbyCrDeviceCharType
        {
            /// <summary> Field "PID_HI" at 0x1, width: 15 bits </summary>
            public IValueRegisterField PID_HI;
            /// <summary> Field "DCR" at 0x10, width: 8 bits </summary>
            public IValueRegisterField DCR;
            /// <summary> Field "BCR_VAR" at 0x18, width: 5 bits </summary>
            public IValueRegisterField BCR_VAR;
            /// <summary> Field "BCR_FIXED" at 0x1d, width: 3 bits </summary>
            public IValueRegisterField BCR_FIXED;

            public StbyCrDeviceCharType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(408, 4294967294, true)
                    .WithValueField(1, 15, out PID_HI, name: "PID_HI")
                    .WithValueField(16, 8, out DCR, name: "DCR")
                    .WithValueField(24, 5, out BCR_VAR, name: "BCR_VAR")
                    .WithValueField(29, 3, out BCR_FIXED, name: "BCR_FIXED");
            }
        }

        public struct StbyCrDevicePidLoType
        {
            /// <summary> Field "PID_LO" at 0x0, width: 32 bits </summary>
            public IValueRegisterField PID_LO;

            public StbyCrDevicePidLoType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(412, 4294967295, true)
                    .WithValueField(0, 32, out PID_LO, name: "PID_LO");
            }
        }

        public struct StbyCrIntrStatusType
        {
            /// <summary> Field "ACR_HANDOFF_OK_REMAIN_STAT" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField ACR_HANDOFF_OK_REMAIN_STAT;
            /// <summary> Field "ACR_HANDOFF_OK_PRIMED_STAT" at 0x1, width: 1 bits </summary>
            public IFlagRegisterField ACR_HANDOFF_OK_PRIMED_STAT;
            /// <summary> Field "ACR_HANDOFF_ERR_FAIL_STAT" at 0x2, width: 1 bits </summary>
            public IFlagRegisterField ACR_HANDOFF_ERR_FAIL_STAT;
            /// <summary> Field "ACR_HANDOFF_ERR_M3_STAT" at 0x3, width: 1 bits </summary>
            public IFlagRegisterField ACR_HANDOFF_ERR_M3_STAT;
            /// <summary> Field "CRR_RESPONSE_STAT" at 0xa, width: 1 bits </summary>
            public IFlagRegisterField CRR_RESPONSE_STAT;
            /// <summary> Field "STBY_CR_DYN_ADDR_STAT" at 0xb, width: 1 bits </summary>
            public IFlagRegisterField STBY_CR_DYN_ADDR_STAT;
            /// <summary> Field "STBY_CR_ACCEPT_NACKED_STAT" at 0xc, width: 1 bits </summary>
            public IFlagRegisterField STBY_CR_ACCEPT_NACKED_STAT;
            /// <summary> Field "STBY_CR_ACCEPT_OK_STAT" at 0xd, width: 1 bits </summary>
            public IFlagRegisterField STBY_CR_ACCEPT_OK_STAT;
            /// <summary> Field "STBY_CR_ACCEPT_ERR_STAT" at 0xe, width: 1 bits </summary>
            public IFlagRegisterField STBY_CR_ACCEPT_ERR_STAT;
            /// <summary> Field "STBY_CR_OP_RSTACT_STAT" at 0x10, width: 1 bits </summary>
            public IFlagRegisterField STBY_CR_OP_RSTACT_STAT;
            /// <summary> Field "CCC_PARAM_MODIFIED_STAT" at 0x11, width: 1 bits </summary>
            public IFlagRegisterField CCC_PARAM_MODIFIED_STAT;
            /// <summary> Field "CCC_UNHANDLED_NACK_STAT" at 0x12, width: 1 bits </summary>
            public IFlagRegisterField CCC_UNHANDLED_NACK_STAT;
            /// <summary> Field "CCC_FATAL_RSTDAA_ERR_STAT" at 0x13, width: 1 bits </summary>
            public IFlagRegisterField CCC_FATAL_RSTDAA_ERR_STAT;

            public StbyCrIntrStatusType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(416, 0, true)
                    .WithFlag(0, out ACR_HANDOFF_OK_REMAIN_STAT, name: "ACR_HANDOFF_OK_REMAIN_STAT")
                    .WithFlag(1, out ACR_HANDOFF_OK_PRIMED_STAT, name: "ACR_HANDOFF_OK_PRIMED_STAT")
                    .WithFlag(2, out ACR_HANDOFF_ERR_FAIL_STAT, name: "ACR_HANDOFF_ERR_FAIL_STAT")
                    .WithFlag(3, out ACR_HANDOFF_ERR_M3_STAT, name: "ACR_HANDOFF_ERR_M3_STAT")
                    .WithFlag(10, out CRR_RESPONSE_STAT, name: "CRR_RESPONSE_STAT")
                    .WithFlag(11, out STBY_CR_DYN_ADDR_STAT, name: "STBY_CR_DYN_ADDR_STAT")
                    .WithFlag(12, out STBY_CR_ACCEPT_NACKED_STAT, name: "STBY_CR_ACCEPT_NACKED_STAT")
                    .WithFlag(13, out STBY_CR_ACCEPT_OK_STAT, name: "STBY_CR_ACCEPT_OK_STAT")
                    .WithFlag(14, out STBY_CR_ACCEPT_ERR_STAT, name: "STBY_CR_ACCEPT_ERR_STAT")
                    .WithFlag(16, out STBY_CR_OP_RSTACT_STAT, name: "STBY_CR_OP_RSTACT_STAT")
                    .WithFlag(17, out CCC_PARAM_MODIFIED_STAT, name: "CCC_PARAM_MODIFIED_STAT")
                    .WithFlag(18, out CCC_UNHANDLED_NACK_STAT, name: "CCC_UNHANDLED_NACK_STAT")
                    .WithFlag(19, out CCC_FATAL_RSTDAA_ERR_STAT, name: "CCC_FATAL_RSTDAA_ERR_STAT");
            }
        }

        public struct Rsvd1Type
        {
            /// <summary> Field "__rsvd" at 0x0, width: 32 bits </summary>
            public IValueRegisterField __RSVD;

            public Rsvd1Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(420, 0, true)
                    .WithValueField(0, 32, out __RSVD, name: "__RSVD");
            }
        }

        public struct StbyCrIntrSignalEnableType
        {
            /// <summary> Field "ACR_HANDOFF_OK_REMAIN_SIGNAL_EN" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField ACR_HANDOFF_OK_REMAIN_SIGNAL_EN;
            /// <summary> Field "ACR_HANDOFF_OK_PRIMED_SIGNAL_EN" at 0x1, width: 1 bits </summary>
            public IFlagRegisterField ACR_HANDOFF_OK_PRIMED_SIGNAL_EN;
            /// <summary> Field "ACR_HANDOFF_ERR_FAIL_SIGNAL_EN" at 0x2, width: 1 bits </summary>
            public IFlagRegisterField ACR_HANDOFF_ERR_FAIL_SIGNAL_EN;
            /// <summary> Field "ACR_HANDOFF_ERR_M3_SIGNAL_EN" at 0x3, width: 1 bits </summary>
            public IFlagRegisterField ACR_HANDOFF_ERR_M3_SIGNAL_EN;
            /// <summary> Field "CRR_RESPONSE_SIGNAL_EN" at 0xa, width: 1 bits </summary>
            public IFlagRegisterField CRR_RESPONSE_SIGNAL_EN;
            /// <summary> Field "STBY_CR_DYN_ADDR_SIGNAL_EN" at 0xb, width: 1 bits </summary>
            public IFlagRegisterField STBY_CR_DYN_ADDR_SIGNAL_EN;
            /// <summary> Field "STBY_CR_ACCEPT_NACKED_SIGNAL_EN" at 0xc, width: 1 bits </summary>
            public IFlagRegisterField STBY_CR_ACCEPT_NACKED_SIGNAL_EN;
            /// <summary> Field "STBY_CR_ACCEPT_OK_SIGNAL_EN" at 0xd, width: 1 bits </summary>
            public IFlagRegisterField STBY_CR_ACCEPT_OK_SIGNAL_EN;
            /// <summary> Field "STBY_CR_ACCEPT_ERR_SIGNAL_EN" at 0xe, width: 1 bits </summary>
            public IFlagRegisterField STBY_CR_ACCEPT_ERR_SIGNAL_EN;
            /// <summary> Field "STBY_CR_OP_RSTACT_SIGNAL_EN" at 0x10, width: 1 bits </summary>
            public IFlagRegisterField STBY_CR_OP_RSTACT_SIGNAL_EN;
            /// <summary> Field "CCC_PARAM_MODIFIED_SIGNAL_EN" at 0x11, width: 1 bits </summary>
            public IFlagRegisterField CCC_PARAM_MODIFIED_SIGNAL_EN;
            /// <summary> Field "CCC_UNHANDLED_NACK_SIGNAL_EN" at 0x12, width: 1 bits </summary>
            public IFlagRegisterField CCC_UNHANDLED_NACK_SIGNAL_EN;
            /// <summary> Field "CCC_FATAL_RSTDAA_ERR_SIGNAL_EN" at 0x13, width: 1 bits </summary>
            public IFlagRegisterField CCC_FATAL_RSTDAA_ERR_SIGNAL_EN;

            public StbyCrIntrSignalEnableType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(424, 0, true)
                    .WithFlag(0, out ACR_HANDOFF_OK_REMAIN_SIGNAL_EN, name: "ACR_HANDOFF_OK_REMAIN_SIGNAL_EN")
                    .WithFlag(1, out ACR_HANDOFF_OK_PRIMED_SIGNAL_EN, name: "ACR_HANDOFF_OK_PRIMED_SIGNAL_EN")
                    .WithFlag(2, out ACR_HANDOFF_ERR_FAIL_SIGNAL_EN, name: "ACR_HANDOFF_ERR_FAIL_SIGNAL_EN")
                    .WithFlag(3, out ACR_HANDOFF_ERR_M3_SIGNAL_EN, name: "ACR_HANDOFF_ERR_M3_SIGNAL_EN")
                    .WithFlag(10, out CRR_RESPONSE_SIGNAL_EN, name: "CRR_RESPONSE_SIGNAL_EN")
                    .WithFlag(11, out STBY_CR_DYN_ADDR_SIGNAL_EN, name: "STBY_CR_DYN_ADDR_SIGNAL_EN")
                    .WithFlag(12, out STBY_CR_ACCEPT_NACKED_SIGNAL_EN, name: "STBY_CR_ACCEPT_NACKED_SIGNAL_EN")
                    .WithFlag(13, out STBY_CR_ACCEPT_OK_SIGNAL_EN, name: "STBY_CR_ACCEPT_OK_SIGNAL_EN")
                    .WithFlag(14, out STBY_CR_ACCEPT_ERR_SIGNAL_EN, name: "STBY_CR_ACCEPT_ERR_SIGNAL_EN")
                    .WithFlag(16, out STBY_CR_OP_RSTACT_SIGNAL_EN, name: "STBY_CR_OP_RSTACT_SIGNAL_EN")
                    .WithFlag(17, out CCC_PARAM_MODIFIED_SIGNAL_EN, name: "CCC_PARAM_MODIFIED_SIGNAL_EN")
                    .WithFlag(18, out CCC_UNHANDLED_NACK_SIGNAL_EN, name: "CCC_UNHANDLED_NACK_SIGNAL_EN")
                    .WithFlag(19, out CCC_FATAL_RSTDAA_ERR_SIGNAL_EN, name: "CCC_FATAL_RSTDAA_ERR_SIGNAL_EN");
            }
        }

        public struct StbyCrIntrForceType
        {
            /// <summary> Field "CRR_RESPONSE_FORCE" at 0xa, width: 1 bits </summary>
            public IFlagRegisterField CRR_RESPONSE_FORCE;
            /// <summary> Field "STBY_CR_DYN_ADDR_FORCE" at 0xb, width: 1 bits </summary>
            public IFlagRegisterField STBY_CR_DYN_ADDR_FORCE;
            /// <summary> Field "STBY_CR_ACCEPT_NACKED_FORCE" at 0xc, width: 1 bits </summary>
            public IFlagRegisterField STBY_CR_ACCEPT_NACKED_FORCE;
            /// <summary> Field "STBY_CR_ACCEPT_OK_FORCE" at 0xd, width: 1 bits </summary>
            public IFlagRegisterField STBY_CR_ACCEPT_OK_FORCE;
            /// <summary> Field "STBY_CR_ACCEPT_ERR_FORCE" at 0xe, width: 1 bits </summary>
            public IFlagRegisterField STBY_CR_ACCEPT_ERR_FORCE;
            /// <summary> Field "STBY_CR_OP_RSTACT_FORCE" at 0x10, width: 1 bits </summary>
            public IFlagRegisterField STBY_CR_OP_RSTACT_FORCE;
            /// <summary> Field "CCC_PARAM_MODIFIED_FORCE" at 0x11, width: 1 bits </summary>
            public IFlagRegisterField CCC_PARAM_MODIFIED_FORCE;
            /// <summary> Field "CCC_UNHANDLED_NACK_FORCE" at 0x12, width: 1 bits </summary>
            public IFlagRegisterField CCC_UNHANDLED_NACK_FORCE;
            /// <summary> Field "CCC_FATAL_RSTDAA_ERR_FORCE" at 0x13, width: 1 bits </summary>
            public IFlagRegisterField CCC_FATAL_RSTDAA_ERR_FORCE;

            public StbyCrIntrForceType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(428, 0, true)
                    .WithFlag(10, out CRR_RESPONSE_FORCE, name: "CRR_RESPONSE_FORCE")
                    .WithFlag(11, out STBY_CR_DYN_ADDR_FORCE, name: "STBY_CR_DYN_ADDR_FORCE")
                    .WithFlag(12, out STBY_CR_ACCEPT_NACKED_FORCE, name: "STBY_CR_ACCEPT_NACKED_FORCE")
                    .WithFlag(13, out STBY_CR_ACCEPT_OK_FORCE, name: "STBY_CR_ACCEPT_OK_FORCE")
                    .WithFlag(14, out STBY_CR_ACCEPT_ERR_FORCE, name: "STBY_CR_ACCEPT_ERR_FORCE")
                    .WithFlag(16, out STBY_CR_OP_RSTACT_FORCE, mode: FieldMode.Write, name: "STBY_CR_OP_RSTACT_FORCE")
                    .WithFlag(17, out CCC_PARAM_MODIFIED_FORCE, name: "CCC_PARAM_MODIFIED_FORCE")
                    .WithFlag(18, out CCC_UNHANDLED_NACK_FORCE, name: "CCC_UNHANDLED_NACK_FORCE")
                    .WithFlag(19, out CCC_FATAL_RSTDAA_ERR_FORCE, name: "CCC_FATAL_RSTDAA_ERR_FORCE");
            }
        }

        public struct StbyCrCccConfigGetcapsType
        {
            /// <summary> Field "F2_CRCAP1_BUS_CONFIG" at 0x0, width: 3 bits </summary>
            public IValueRegisterField F2_CRCAP1_BUS_CONFIG;
            /// <summary> Field "F2_CRCAP2_DEV_INTERACT" at 0x8, width: 4 bits </summary>
            public IValueRegisterField F2_CRCAP2_DEV_INTERACT;

            public StbyCrCccConfigGetcapsType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(432, 0, true)
                    .WithValueField(0, 3, out F2_CRCAP1_BUS_CONFIG, name: "F2_CRCAP1_BUS_CONFIG")
                    .WithValueField(8, 4, out F2_CRCAP2_DEV_INTERACT, name: "F2_CRCAP2_DEV_INTERACT");
            }
        }

        public struct StbyCrCccConfigRstactParamsType
        {
            /// <summary> Field "RST_ACTION" at 0x0, width: 8 bits </summary>
            public IValueRegisterField RST_ACTION;
            /// <summary> Field "RESET_TIME_PERIPHERAL" at 0x8, width: 8 bits </summary>
            public IValueRegisterField RESET_TIME_PERIPHERAL;
            /// <summary> Field "RESET_TIME_TARGET" at 0x10, width: 8 bits </summary>
            public IValueRegisterField RESET_TIME_TARGET;
            /// <summary> Field "RESET_DYNAMIC_ADDR" at 0x1f, width: 1 bits </summary>
            public IFlagRegisterField RESET_DYNAMIC_ADDR;

            public StbyCrCccConfigRstactParamsType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(436, 2147483648, true)
                    .WithValueField(0, 8, out RST_ACTION, mode: FieldMode.Read, name: "RST_ACTION")
                    .WithValueField(8, 8, out RESET_TIME_PERIPHERAL, name: "RESET_TIME_PERIPHERAL")
                    .WithValueField(16, 8, out RESET_TIME_TARGET, name: "RESET_TIME_TARGET")
                    .WithFlag(31, out RESET_DYNAMIC_ADDR, name: "RESET_DYNAMIC_ADDR");
            }
        }

        public struct StbyCrVirtDeviceAddrType
        {
            /// <summary> Field "VIRT_STATIC_ADDR" at 0x0, width: 7 bits </summary>
            public IValueRegisterField VIRT_STATIC_ADDR;
            /// <summary> Field "VIRT_STATIC_ADDR_VALID" at 0xf, width: 1 bits </summary>
            public IFlagRegisterField VIRT_STATIC_ADDR_VALID;
            /// <summary> Field "VIRT_DYNAMIC_ADDR" at 0x10, width: 7 bits </summary>
            public IValueRegisterField VIRT_DYNAMIC_ADDR;
            /// <summary> Field "VIRT_DYNAMIC_ADDR_VALID" at 0x1f, width: 1 bits </summary>
            public IFlagRegisterField VIRT_DYNAMIC_ADDR_VALID;

            public StbyCrVirtDeviceAddrType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(440, 0, true)
                    .WithValueField(0, 7, out VIRT_STATIC_ADDR, name: "VIRT_STATIC_ADDR")
                    .WithFlag(15, out VIRT_STATIC_ADDR_VALID, name: "VIRT_STATIC_ADDR_VALID")
                    .WithValueField(16, 7, out VIRT_DYNAMIC_ADDR, name: "VIRT_DYNAMIC_ADDR")
                    .WithFlag(31, out VIRT_DYNAMIC_ADDR_VALID, name: "VIRT_DYNAMIC_ADDR_VALID");
            }
        }

        public struct Rsvd3Type
        {
            /// <summary> Field "__rsvd" at 0x0, width: 32 bits </summary>
            public IValueRegisterField __RSVD;

            public Rsvd3Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(444, 0, true)
                    .WithValueField(0, 32, out __RSVD, name: "__RSVD");
            }
        }

        public struct ControlType
        {
            /// <summary> Field "HJ_EN" at 0xa, width: 1 bits </summary>
            public IFlagRegisterField HJ_EN;
            /// <summary> Field "CRR_EN" at 0xb, width: 1 bits </summary>
            public IFlagRegisterField CRR_EN;
            /// <summary> Field "IBI_EN" at 0xc, width: 1 bits </summary>
            public IFlagRegisterField IBI_EN;
            /// <summary> Field "IBI_RETRY_NUM" at 0xd, width: 3 bits </summary>
            public IValueRegisterField IBI_RETRY_NUM;

            public ControlType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(452, 5120, true)
                    .WithFlag(10, out HJ_EN, name: "HJ_EN")
                    .WithFlag(11, out CRR_EN, name: "CRR_EN")
                    .WithFlag(12, out IBI_EN, name: "IBI_EN")
                    .WithValueField(13, 3, out IBI_RETRY_NUM, name: "IBI_RETRY_NUM");
            }
        }

        public struct StatusType
        {
            /// <summary> Field "PROTOCOL_ERROR" at 0xd, width: 1 bits </summary>
            public IFlagRegisterField PROTOCOL_ERROR;
            /// <summary> Field "LAST_IBI_STATUS" at 0xe, width: 2 bits </summary>
            public IValueRegisterField LAST_IBI_STATUS;

            public StatusType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(456, 0, true)
                    .WithFlag(13, out PROTOCOL_ERROR, mode: FieldMode.Read, name: "PROTOCOL_ERROR")
                    .WithValueField(14, 2, out LAST_IBI_STATUS, mode: FieldMode.Read, name: "LAST_IBI_STATUS");
            }
        }

        public struct InterruptStatusType
        {
            /// <summary> Field "RX_DESC_STAT" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField RX_DESC_STAT;
            /// <summary> Field "TX_DESC_STAT" at 0x1, width: 1 bits </summary>
            public IFlagRegisterField TX_DESC_STAT;
            /// <summary> Field "RX_DESC_TIMEOUT" at 0x2, width: 1 bits </summary>
            public IFlagRegisterField RX_DESC_TIMEOUT;
            /// <summary> Field "TX_DESC_TIMEOUT" at 0x3, width: 1 bits </summary>
            public IFlagRegisterField TX_DESC_TIMEOUT;
            /// <summary> Field "TX_DATA_THLD_STAT" at 0x8, width: 1 bits </summary>
            public IFlagRegisterField TX_DATA_THLD_STAT;
            /// <summary> Field "RX_DATA_THLD_STAT" at 0x9, width: 1 bits </summary>
            public IFlagRegisterField RX_DATA_THLD_STAT;
            /// <summary> Field "TX_DESC_THLD_STAT" at 0xa, width: 1 bits </summary>
            public IFlagRegisterField TX_DESC_THLD_STAT;
            /// <summary> Field "RX_DESC_THLD_STAT" at 0xb, width: 1 bits </summary>
            public IFlagRegisterField RX_DESC_THLD_STAT;
            /// <summary> Field "IBI_THLD_STAT" at 0xc, width: 1 bits </summary>
            public IFlagRegisterField IBI_THLD_STAT;
            /// <summary> Field "IBI_DONE" at 0xd, width: 1 bits </summary>
            public IFlagRegisterField IBI_DONE;
            /// <summary> Field "PENDING_INTERRUPT" at 0xf, width: 4 bits </summary>
            public IValueRegisterField PENDING_INTERRUPT;
            /// <summary> Field "TRANSFER_ABORT_STAT" at 0x19, width: 1 bits </summary>
            public IFlagRegisterField TRANSFER_ABORT_STAT;
            /// <summary> Field "TRANSFER_ERR_STAT" at 0x1f, width: 1 bits </summary>
            public IFlagRegisterField TRANSFER_ERR_STAT;

            public InterruptStatusType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(464, 0, true)
                    .WithFlag(0, out RX_DESC_STAT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "RX_DESC_STAT")
                    .WithFlag(1, out TX_DESC_STAT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "TX_DESC_STAT")
                    .WithFlag(2, out RX_DESC_TIMEOUT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "RX_DESC_TIMEOUT")
                    .WithFlag(3, out TX_DESC_TIMEOUT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "TX_DESC_TIMEOUT")
                    .WithFlag(8, out TX_DATA_THLD_STAT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "TX_DATA_THLD_STAT")
                    .WithFlag(9, out RX_DATA_THLD_STAT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "RX_DATA_THLD_STAT")
                    .WithFlag(10, out TX_DESC_THLD_STAT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "TX_DESC_THLD_STAT")
                    .WithFlag(11, out RX_DESC_THLD_STAT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "RX_DESC_THLD_STAT")
                    .WithFlag(12, out IBI_THLD_STAT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "IBI_THLD_STAT")
                    .WithFlag(13, out IBI_DONE, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "IBI_DONE")
                    .WithValueField(15, 4, out PENDING_INTERRUPT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "PENDING_INTERRUPT")
                    .WithFlag(25, out TRANSFER_ABORT_STAT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "TRANSFER_ABORT_STAT")
                    .WithFlag(31, out TRANSFER_ERR_STAT, mode: FieldMode.Read | FieldMode.WriteOneToClear, name: "TRANSFER_ERR_STAT");
            }
        }

        public struct InterruptEnableType
        {
            /// <summary> Field "RX_DESC_STAT_EN" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField RX_DESC_STAT_EN;
            /// <summary> Field "TX_DESC_STAT_EN" at 0x1, width: 1 bits </summary>
            public IFlagRegisterField TX_DESC_STAT_EN;
            /// <summary> Field "RX_DESC_TIMEOUT_EN" at 0x2, width: 1 bits </summary>
            public IFlagRegisterField RX_DESC_TIMEOUT_EN;
            /// <summary> Field "TX_DESC_TIMEOUT_EN" at 0x3, width: 1 bits </summary>
            public IFlagRegisterField TX_DESC_TIMEOUT_EN;
            /// <summary> Field "TX_DATA_THLD_STAT_EN" at 0x8, width: 1 bits </summary>
            public IFlagRegisterField TX_DATA_THLD_STAT_EN;
            /// <summary> Field "RX_DATA_THLD_STAT_EN" at 0x9, width: 1 bits </summary>
            public IFlagRegisterField RX_DATA_THLD_STAT_EN;
            /// <summary> Field "TX_DESC_THLD_STAT_EN" at 0xa, width: 1 bits </summary>
            public IFlagRegisterField TX_DESC_THLD_STAT_EN;
            /// <summary> Field "RX_DESC_THLD_STAT_EN" at 0xb, width: 1 bits </summary>
            public IFlagRegisterField RX_DESC_THLD_STAT_EN;
            /// <summary> Field "IBI_THLD_STAT_EN" at 0xc, width: 1 bits </summary>
            public IFlagRegisterField IBI_THLD_STAT_EN;
            /// <summary> Field "IBI_DONE_EN" at 0xd, width: 1 bits </summary>
            public IFlagRegisterField IBI_DONE_EN;
            /// <summary> Field "TRANSFER_ABORT_STAT_EN" at 0x19, width: 1 bits </summary>
            public IFlagRegisterField TRANSFER_ABORT_STAT_EN;
            /// <summary> Field "TRANSFER_ERR_STAT_EN" at 0x1f, width: 1 bits </summary>
            public IFlagRegisterField TRANSFER_ERR_STAT_EN;

            public InterruptEnableType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(468, 0, true)
                    .WithFlag(0, out RX_DESC_STAT_EN, name: "RX_DESC_STAT_EN")
                    .WithFlag(1, out TX_DESC_STAT_EN, name: "TX_DESC_STAT_EN")
                    .WithFlag(2, out RX_DESC_TIMEOUT_EN, name: "RX_DESC_TIMEOUT_EN")
                    .WithFlag(3, out TX_DESC_TIMEOUT_EN, name: "TX_DESC_TIMEOUT_EN")
                    .WithFlag(8, out TX_DATA_THLD_STAT_EN, name: "TX_DATA_THLD_STAT_EN")
                    .WithFlag(9, out RX_DATA_THLD_STAT_EN, name: "RX_DATA_THLD_STAT_EN")
                    .WithFlag(10, out TX_DESC_THLD_STAT_EN, name: "TX_DESC_THLD_STAT_EN")
                    .WithFlag(11, out RX_DESC_THLD_STAT_EN, name: "RX_DESC_THLD_STAT_EN")
                    .WithFlag(12, out IBI_THLD_STAT_EN, name: "IBI_THLD_STAT_EN")
                    .WithFlag(13, out IBI_DONE_EN, name: "IBI_DONE_EN")
                    .WithFlag(25, out TRANSFER_ABORT_STAT_EN, name: "TRANSFER_ABORT_STAT_EN")
                    .WithFlag(31, out TRANSFER_ERR_STAT_EN, name: "TRANSFER_ERR_STAT_EN");
            }
        }

        public struct InterruptForceType
        {
            /// <summary> Field "RX_DESC_STAT_FORCE" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField RX_DESC_STAT_FORCE;
            /// <summary> Field "TX_DESC_STAT_FORCE" at 0x1, width: 1 bits </summary>
            public IFlagRegisterField TX_DESC_STAT_FORCE;
            /// <summary> Field "RX_DESC_TIMEOUT_FORCE" at 0x2, width: 1 bits </summary>
            public IFlagRegisterField RX_DESC_TIMEOUT_FORCE;
            /// <summary> Field "TX_DESC_TIMEOUT_FORCE" at 0x3, width: 1 bits </summary>
            public IFlagRegisterField TX_DESC_TIMEOUT_FORCE;
            /// <summary> Field "TX_DATA_THLD_FORCE" at 0x8, width: 1 bits </summary>
            public IFlagRegisterField TX_DATA_THLD_FORCE;
            /// <summary> Field "RX_DATA_THLD_FORCE" at 0x9, width: 1 bits </summary>
            public IFlagRegisterField RX_DATA_THLD_FORCE;
            /// <summary> Field "TX_DESC_THLD_FORCE" at 0xa, width: 1 bits </summary>
            public IFlagRegisterField TX_DESC_THLD_FORCE;
            /// <summary> Field "RX_DESC_THLD_FORCE" at 0xb, width: 1 bits </summary>
            public IFlagRegisterField RX_DESC_THLD_FORCE;
            /// <summary> Field "IBI_THLD_FORCE" at 0xc, width: 1 bits </summary>
            public IFlagRegisterField IBI_THLD_FORCE;
            /// <summary> Field "IBI_DONE_FORCE" at 0xd, width: 1 bits </summary>
            public IFlagRegisterField IBI_DONE_FORCE;
            /// <summary> Field "TRANSFER_ABORT_STAT_FORCE" at 0x19, width: 1 bits </summary>
            public IFlagRegisterField TRANSFER_ABORT_STAT_FORCE;
            /// <summary> Field "TRANSFER_ERR_STAT_FORCE" at 0x1f, width: 1 bits </summary>
            public IFlagRegisterField TRANSFER_ERR_STAT_FORCE;

            public InterruptForceType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(472, 0, true)
                    .WithFlag(0, out RX_DESC_STAT_FORCE, name: "RX_DESC_STAT_FORCE")
                    .WithFlag(1, out TX_DESC_STAT_FORCE, name: "TX_DESC_STAT_FORCE")
                    .WithFlag(2, out RX_DESC_TIMEOUT_FORCE, name: "RX_DESC_TIMEOUT_FORCE")
                    .WithFlag(3, out TX_DESC_TIMEOUT_FORCE, name: "TX_DESC_TIMEOUT_FORCE")
                    .WithFlag(8, out TX_DATA_THLD_FORCE, name: "TX_DATA_THLD_FORCE")
                    .WithFlag(9, out RX_DATA_THLD_FORCE, name: "RX_DATA_THLD_FORCE")
                    .WithFlag(10, out TX_DESC_THLD_FORCE, name: "TX_DESC_THLD_FORCE")
                    .WithFlag(11, out RX_DESC_THLD_FORCE, name: "RX_DESC_THLD_FORCE")
                    .WithFlag(12, out IBI_THLD_FORCE, name: "IBI_THLD_FORCE")
                    .WithFlag(13, out IBI_DONE_FORCE, name: "IBI_DONE_FORCE")
                    .WithFlag(25, out TRANSFER_ABORT_STAT_FORCE, name: "TRANSFER_ABORT_STAT_FORCE")
                    .WithFlag(31, out TRANSFER_ERR_STAT_FORCE, name: "TRANSFER_ERR_STAT_FORCE");
            }
        }

        public struct RxDescQueuePortType
        {
            /// <summary> Field "RX_DESC" at 0x0, width: 32 bits </summary>
            public IValueRegisterField RX_DESC;

            public RxDescQueuePortType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(476, 0, true)
                    .WithValueField(0, 32, out RX_DESC, mode: FieldMode.Read, name: "RX_DESC");
            }
        }

        public struct TxDescQueuePortType
        {
            /// <summary> Field "TX_DESC" at 0x0, width: 32 bits </summary>
            public IValueRegisterField TX_DESC;

            public TxDescQueuePortType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(484, 0, true)
                    .WithValueField(0, 32, out TX_DESC, mode: FieldMode.Write, name: "TX_DESC");
            }
        }

        public struct IbiQueueSizeType
        {
            /// <summary> Field "IBI_QUEUE_SIZE" at 0x0, width: 8 bits </summary>
            public IValueRegisterField IBI_QUEUE_SIZE;

            public IbiQueueSizeType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(500, 255, true)
                    .WithValueField(0, 8, out IBI_QUEUE_SIZE, mode: FieldMode.Read, name: "IBI_QUEUE_SIZE");
            }
        }

        public struct SocMgmtControlType
        {
            /// <summary> Field "PLACEHOLDER" at 0x0, width: 32 bits </summary>
            public IValueRegisterField PLACEHOLDER;

            public SocMgmtControlType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(516, 0, true)
                    .WithValueField(0, 32, out PLACEHOLDER, name: "PLACEHOLDER");
            }
        }

        public struct SocMgmtStatusType
        {
            /// <summary> Field "PLACEHOLDER" at 0x0, width: 32 bits </summary>
            public IValueRegisterField PLACEHOLDER;

            public SocMgmtStatusType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(520, 0, true)
                    .WithValueField(0, 32, out PLACEHOLDER, name: "PLACEHOLDER");
            }
        }

        public struct SocMgmtRsvd0Type
        {
            /// <summary> Field "PLACEHOLDER" at 0x0, width: 32 bits </summary>
            public IValueRegisterField PLACEHOLDER;

            public SocMgmtRsvd0Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(524, 0, true)
                    .WithValueField(0, 32, out PLACEHOLDER, name: "PLACEHOLDER");
            }
        }

        public struct SocMgmtRsvd1Type
        {
            /// <summary> Field "PLACEHOLDER" at 0x0, width: 32 bits </summary>
            public IValueRegisterField PLACEHOLDER;

            public SocMgmtRsvd1Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(528, 0, true)
                    .WithValueField(0, 32, out PLACEHOLDER, name: "PLACEHOLDER");
            }
        }

        public struct SocMgmtRsvd2Type
        {
            /// <summary> Field "PLACEHOLDER" at 0x0, width: 32 bits </summary>
            public IValueRegisterField PLACEHOLDER;

            public SocMgmtRsvd2Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(532, 0, true)
                    .WithValueField(0, 32, out PLACEHOLDER, name: "PLACEHOLDER");
            }
        }

        public struct SocMgmtRsvd3Type
        {
            /// <summary> Field "PLACEHOLDER" at 0x0, width: 32 bits </summary>
            public IValueRegisterField PLACEHOLDER;

            public SocMgmtRsvd3Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(536, 0, true)
                    .WithValueField(0, 32, out PLACEHOLDER, name: "PLACEHOLDER");
            }
        }

        public struct SocPadConfType
        {
            /// <summary> Field "INPUT_ENABLE" at 0x0, width: 1 bits </summary>
            public IFlagRegisterField INPUT_ENABLE;
            /// <summary> Field "SCHMITT_EN" at 0x1, width: 1 bits </summary>
            public IFlagRegisterField SCHMITT_EN;
            /// <summary> Field "KEEPER_EN" at 0x2, width: 1 bits </summary>
            public IFlagRegisterField KEEPER_EN;
            /// <summary> Field "PULL_DIR" at 0x3, width: 1 bits </summary>
            public IFlagRegisterField PULL_DIR;
            /// <summary> Field "PULL_EN" at 0x4, width: 1 bits </summary>
            public IFlagRegisterField PULL_EN;
            /// <summary> Field "IO_INVERSION" at 0x5, width: 1 bits </summary>
            public IFlagRegisterField IO_INVERSION;
            /// <summary> Field "OD_EN" at 0x6, width: 1 bits </summary>
            public IFlagRegisterField OD_EN;
            /// <summary> Field "VIRTUAL_OD_EN" at 0x7, width: 1 bits </summary>
            public IFlagRegisterField VIRTUAL_OD_EN;
            /// <summary> Field "PAD_TYPE" at 0x18, width: 8 bits </summary>
            public IValueRegisterField PAD_TYPE;

            public SocPadConfType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(540, 4278190081, true)
                    .WithFlag(0, out INPUT_ENABLE, name: "INPUT_ENABLE")
                    .WithFlag(1, out SCHMITT_EN, name: "SCHMITT_EN")
                    .WithFlag(2, out KEEPER_EN, name: "KEEPER_EN")
                    .WithFlag(3, out PULL_DIR, name: "PULL_DIR")
                    .WithFlag(4, out PULL_EN, name: "PULL_EN")
                    .WithFlag(5, out IO_INVERSION, name: "IO_INVERSION")
                    .WithFlag(6, out OD_EN, name: "OD_EN")
                    .WithFlag(7, out VIRTUAL_OD_EN, name: "VIRTUAL_OD_EN")
                    .WithValueField(24, 8, out PAD_TYPE, name: "PAD_TYPE");
            }
        }

        public struct SocPadAttrType
        {
            /// <summary> Field "DRIVE_SLEW_RATE" at 0x8, width: 8 bits </summary>
            public IValueRegisterField DRIVE_SLEW_RATE;
            /// <summary> Field "DRIVE_STRENGTH" at 0x18, width: 8 bits </summary>
            public IValueRegisterField DRIVE_STRENGTH;

            public SocPadAttrType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(544, 4278255360, true)
                    .WithValueField(8, 8, out DRIVE_SLEW_RATE, name: "DRIVE_SLEW_RATE")
                    .WithValueField(24, 8, out DRIVE_STRENGTH, name: "DRIVE_STRENGTH");
            }
        }

        public struct SocMgmtFeature2Type
        {
            /// <summary> Field "PLACEHOLDER" at 0x0, width: 32 bits </summary>
            public IValueRegisterField PLACEHOLDER;

            public SocMgmtFeature2Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(548, 0, true)
                    .WithValueField(0, 32, out PLACEHOLDER, name: "PLACEHOLDER");
            }
        }

        public struct SocMgmtFeature3Type
        {
            /// <summary> Field "PLACEHOLDER" at 0x0, width: 32 bits </summary>
            public IValueRegisterField PLACEHOLDER;

            public SocMgmtFeature3Type(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(552, 0, true)
                    .WithValueField(0, 32, out PLACEHOLDER, name: "PLACEHOLDER");
            }
        }

        public struct TRRegType
        {
            /// <summary> Field "T_R" at 0x0, width: 20 bits </summary>
            public IValueRegisterField T_R;

            public TRRegType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(556, 0, true)
                    .WithValueField(0, 20, out T_R, name: "T_R");
            }
        }

        public struct TFRegType
        {
            /// <summary> Field "T_F" at 0x0, width: 20 bits </summary>
            public IValueRegisterField T_F;

            public TFRegType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(560, 0, true)
                    .WithValueField(0, 20, out T_F, name: "T_F");
            }
        }

        public struct TSuDatRegType
        {
            /// <summary> Field "T_SU_DAT" at 0x0, width: 20 bits </summary>
            public IValueRegisterField T_SU_DAT;

            public TSuDatRegType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(564, 0, true)
                    .WithValueField(0, 20, out T_SU_DAT, name: "T_SU_DAT");
            }
        }

        public struct THdDatRegType
        {
            /// <summary> Field "T_HD_DAT" at 0x0, width: 20 bits </summary>
            public IValueRegisterField T_HD_DAT;

            public THdDatRegType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(568, 0, true)
                    .WithValueField(0, 20, out T_HD_DAT, name: "T_HD_DAT");
            }
        }

        public struct THighRegType
        {
            /// <summary> Field "T_HIGH" at 0x0, width: 20 bits </summary>
            public IValueRegisterField T_HIGH;

            public THighRegType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(572, 0, true)
                    .WithValueField(0, 20, out T_HIGH, name: "T_HIGH");
            }
        }

        public struct TLowRegType
        {
            /// <summary> Field "T_LOW" at 0x0, width: 20 bits </summary>
            public IValueRegisterField T_LOW;

            public TLowRegType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(576, 0, true)
                    .WithValueField(0, 20, out T_LOW, name: "T_LOW");
            }
        }

        public struct THdStaRegType
        {
            /// <summary> Field "T_HD_STA" at 0x0, width: 20 bits </summary>
            public IValueRegisterField T_HD_STA;

            public THdStaRegType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(580, 0, true)
                    .WithValueField(0, 20, out T_HD_STA, name: "T_HD_STA");
            }
        }

        public struct TSuStaRegType
        {
            /// <summary> Field "T_SU_STA" at 0x0, width: 20 bits </summary>
            public IValueRegisterField T_SU_STA;

            public TSuStaRegType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(584, 0, true)
                    .WithValueField(0, 20, out T_SU_STA, name: "T_SU_STA");
            }
        }

        public struct TSuStoRegType
        {
            /// <summary> Field "T_SU_STO" at 0x0, width: 20 bits </summary>
            public IValueRegisterField T_SU_STO;

            public TSuStoRegType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(588, 0, true)
                    .WithValueField(0, 20, out T_SU_STO, name: "T_SU_STO");
            }
        }

        public struct TFreeRegType
        {
            /// <summary> Field "T_FREE" at 0x0, width: 32 bits </summary>
            public IValueRegisterField T_FREE;

            public TFreeRegType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(592, 4294967295, true)
                    .WithValueField(0, 32, out T_FREE, name: "T_FREE");
            }
        }

        public struct TAvalRegType
        {
            /// <summary> Field "T_AVAL" at 0x0, width: 32 bits </summary>
            public IValueRegisterField T_AVAL;

            public TAvalRegType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(596, 4294967295, true)
                    .WithValueField(0, 32, out T_AVAL, name: "T_AVAL");
            }
        }

        public struct TIdleRegType
        {
            /// <summary> Field "T_IDLE" at 0x0, width: 32 bits </summary>
            public IValueRegisterField T_IDLE;

            public TIdleRegType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(600, 4294967295, true)
                    .WithValueField(0, 32, out T_IDLE, name: "T_IDLE");
            }
        }

        public struct ControllerConfigType
        {
            /// <summary> Field "OPERATION_MODE" at 0x4, width: 2 bits </summary>
            public IValueRegisterField OPERATION_MODE;

            public ControllerConfigType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(612, 48, true)
                    .WithValueField(4, 2, out OPERATION_MODE, mode: FieldMode.Read, name: "OPERATION_MODE");
            }
        }

        public struct TerminationExtcapHeaderType
        {
            /// <summary> Field "CAP_ID" at 0x0, width: 8 bits </summary>
            public IValueRegisterField CAP_ID;
            /// <summary> Field "CAP_LENGTH" at 0x8, width: 16 bits </summary>
            public IValueRegisterField CAP_LENGTH;

            public TerminationExtcapHeaderType(IProvidesRegisterCollection<DoubleWordRegisterCollection> parent)
            {
                parent.RegistersCollection.DefineRegister(616, 16776960, true)
                    .WithValueField(0, 8, out CAP_ID, mode: FieldMode.Read, name: "CAP_ID")
                    .WithValueField(8, 16, out CAP_LENGTH, mode: FieldMode.Read, name: "CAP_LENGTH");
            }
        }

        protected class Dat_DatMemoryContainer
        {
            private byte[] memory;

            public long Size {
                get
                {
                    return 1024L;
                }
            }
            public Dat_DatMemoryWrapper this[long index] {
                get
                {
                    if(index < 0 || index >= 128)
                    {
                        throw new System.IndexOutOfRangeException();
                    }
                    return new Dat_DatMemoryWrapper(memory, index * 8);
                }
            }

            public Dat_DatMemoryContainer()
            {
                memory = new byte[Size];
            }

            public uint ReadDoubleWord(long offset)
            {
                return (uint)memory[offset] + ((uint)memory[offset + 1] << 8) + ((uint)memory[offset + 2] << 16) + ((uint)memory[offset + 3] << 24);
            }

            public void WriteDoubleWord(long offset, uint value)
            {
                memory[offset] = (byte)value;
                memory[offset + 1] = (byte)(value >> 8);
                memory[offset + 2] = (byte)(value >> 16);
                memory[offset + 3] = (byte)(value >> 24);
            }

            public class Dat_DatMemoryWrapper
            {
                private long spanBegin;
                private byte[] memory;

                /// <summary> Offset: 0x0, Width: 7 bits </summary>
                public byte STATIC_ADDRESS {
                    get
                    {
                        byte temp = 0;
                        temp = (byte)(temp | (byte)(memory[spanBegin + 0] & 0x7f));
                        return temp;
                    }
                    set
                    {
                        memory[spanBegin + 0] = (byte)(memory[spanBegin + 0] & 0x80U | value & 0x7fU);
                    }
                }
                /// <summary> Offset: 0xc, Width: 1 bits </summary>
                public bool IBI_PAYLOAD {
                    get
                    {
                        bool temp;
                        temp = (memory[spanBegin + 1] & 0x10) != 0;
                        return temp;
                    }
                    set
                    {
                        memory[spanBegin + 1] = (byte)(memory[spanBegin + 1] & 0xefU | (value ? 1U : 0U) << 4);
                    }
                }
                /// <summary> Offset: 0xd, Width: 1 bits </summary>
                public bool IBI_REJECT {
                    get
                    {
                        bool temp;
                        temp = (memory[spanBegin + 1] & 0x20) != 0;
                        return temp;
                    }
                    set
                    {
                        memory[spanBegin + 1] = (byte)(memory[spanBegin + 1] & 0xdfU | (value ? 1U : 0U) << 5);
                    }
                }
                /// <summary> Offset: 0xe, Width: 1 bits </summary>
                public bool CRR_REJECT {
                    get
                    {
                        bool temp;
                        temp = (memory[spanBegin + 1] & 0x40) != 0;
                        return temp;
                    }
                    set
                    {
                        memory[spanBegin + 1] = (byte)(memory[spanBegin + 1] & 0xbfU | (value ? 1U : 0U) << 6);
                    }
                }
                /// <summary> Offset: 0xf, Width: 1 bits </summary>
                public bool TS {
                    get
                    {
                        bool temp;
                        temp = (memory[spanBegin + 1] & 0x80) != 0;
                        return temp;
                    }
                    set
                    {
                        memory[spanBegin + 1] = (byte)(memory[spanBegin + 1] & 0x7fU | (value ? 1U : 0U) << 7);
                    }
                }
                /// <summary> Offset: 0x10, Width: 8 bits </summary>
                public byte DYNAMIC_ADDRESS {
                    get
                    {
                        byte temp = 0;
                        temp = (byte)(temp | (byte)memory[spanBegin + 2]);
                        return temp;
                    }
                    set
                    {
                        memory[spanBegin + 2] = (byte)value;
                    }
                }
                /// <summary> Offset: 0x1a, Width: 3 bits </summary>
                public byte RING_ID {
                    get
                    {
                        byte temp = 0;
                        temp = (byte)(temp | (byte)(memory[spanBegin + 3] & 0x1c) >> 2);
                        return temp;
                    }
                    set
                    {
                        memory[spanBegin + 3] = (byte)(memory[spanBegin + 3] & 0xe3U | (value & 0x7U) << 2);
                    }
                }
                /// <summary> Offset: 0x1d, Width: 2 bits </summary>
                public byte DEV_NACK_RETRY_CNT {
                    get
                    {
                        byte temp = 0;
                        temp = (byte)(temp | (byte)(memory[spanBegin + 3] & 0x60) >> 5);
                        return temp;
                    }
                    set
                    {
                        memory[spanBegin + 3] = (byte)(memory[spanBegin + 3] & 0x9fU | (value & 0x3U) << 5);
                    }
                }
                /// <summary> Offset: 0x1f, Width: 1 bits </summary>
                public bool DEVICE {
                    get
                    {
                        bool temp;
                        temp = (memory[spanBegin + 3] & 0x80) != 0;
                        return temp;
                    }
                    set
                    {
                        memory[spanBegin + 3] = (byte)(memory[spanBegin + 3] & 0x7fU | (value ? 1U : 0U) << 7);
                    }
                }
                /// <summary> Offset: 0x20, Width: 8 bits </summary>
                public byte AUTOCMD_MASK {
                    get
                    {
                        byte temp = 0;
                        temp = (byte)(temp | (byte)memory[spanBegin + 4]);
                        return temp;
                    }
                    set
                    {
                        memory[spanBegin + 4] = (byte)value;
                    }
                }
                /// <summary> Offset: 0x28, Width: 8 bits </summary>
                public byte AUTOCMD_VALUE {
                    get
                    {
                        byte temp = 0;
                        temp = (byte)(temp | (byte)memory[spanBegin + 5]);
                        return temp;
                    }
                    set
                    {
                        memory[spanBegin + 5] = (byte)value;
                    }
                }
                /// <summary> Offset: 0x30, Width: 3 bits </summary>
                public byte AUTOCMD_MODE {
                    get
                    {
                        byte temp = 0;
                        temp = (byte)(temp | (byte)(memory[spanBegin + 6] & 0x7));
                        return temp;
                    }
                    set
                    {
                        memory[spanBegin + 6] = (byte)(memory[spanBegin + 6] & 0xf8U | value & 0x7U);
                    }
                }
                /// <summary> Offset: 0x33, Width: 8 bits </summary>
                public byte AUTOCMD_HDR_CODE {
                    get
                    {
                        byte temp = 0;
                        temp = (byte)(temp | (byte)(memory[spanBegin + 6] & 0xf8) >> 3);
                        return temp;
                    }
                    set
                    {
                        memory[spanBegin + 6] = (byte)(memory[spanBegin + 6] & 0x7U | value << 3);
                    }
                }

                public Dat_DatMemoryWrapper(byte[] memory, long spanBegin)
                {
                    this.memory = memory;
                    this.spanBegin = spanBegin;
                }
            }
        }

        protected class Dct_DctMemoryContainer
        {
            private byte[] memory;

            public long Size {
                get
                {
                    return 2048L;
                }
            }
            public Dct_DctMemoryWrapper this[long index] {
                get
                {
                    if(index < 0 || index >= 128)
                    {
                        throw new System.IndexOutOfRangeException();
                    }
                    return new Dct_DctMemoryWrapper(memory, index * 16);
                }
            }

            public Dct_DctMemoryContainer()
            {
                memory = new byte[Size];
            }

            public uint ReadDoubleWord(long offset)
            {
                return (uint)memory[offset] + ((uint)memory[offset + 1] << 8) + ((uint)memory[offset + 2] << 16) + ((uint)memory[offset + 3] << 24);
            }

            public void WriteDoubleWord(long offset, uint value)
            {
                memory[offset] = (byte)value;
                memory[offset + 1] = (byte)(value >> 8);
                memory[offset + 2] = (byte)(value >> 16);
                memory[offset + 3] = (byte)(value >> 24);
            }

            public class Dct_DctMemoryWrapper
            {
                private long spanBegin;
                private byte[] memory;

                /// <summary> Offset: 0x0, Width: 32 bits </summary>
                public uint PID_HI {
                    get
                    {
                        uint temp = 0;
                        temp = (uint)(temp | (uint)memory[spanBegin + 0]);
                        temp = (uint)(temp | (uint)memory[spanBegin + 1] << 8);
                        temp = (uint)(temp | (uint)memory[spanBegin + 2] << 16);
                        temp = (uint)(temp | (uint)memory[spanBegin + 3] << 24);
                        return temp;
                    }
                    set
                    {
                        memory[spanBegin + 0] = (byte)value;
                        memory[spanBegin + 1] = (byte)(value >> 8);
                        memory[spanBegin + 2] = (byte)(value >> 16);
                        memory[spanBegin + 3] = (byte)(value >> 24);
                    }
                }
                /// <summary> Offset: 0x20, Width: 16 bits </summary>
                public ushort PID_LO {
                    get
                    {
                        ushort temp = 0;
                        temp = (ushort)(temp | (ushort)memory[spanBegin + 4]);
                        temp = (ushort)(temp | (ushort)memory[spanBegin + 5] << 8);
                        return temp;
                    }
                    set
                    {
                        memory[spanBegin + 4] = (byte)value;
                        memory[spanBegin + 5] = (byte)(value >> 8);
                    }
                }
                /// <summary> Offset: 0x40, Width: 8 bits </summary>
                public byte DCR {
                    get
                    {
                        byte temp = 0;
                        temp = (byte)(temp | (byte)memory[spanBegin + 8]);
                        return temp;
                    }
                    set
                    {
                        memory[spanBegin + 8] = (byte)value;
                    }
                }
                /// <summary> Offset: 0x48, Width: 8 bits </summary>
                public byte BCR {
                    get
                    {
                        byte temp = 0;
                        temp = (byte)(temp | (byte)memory[spanBegin + 9]);
                        return temp;
                    }
                    set
                    {
                        memory[spanBegin + 9] = (byte)value;
                    }
                }
                /// <summary> Offset: 0x60, Width: 8 bits </summary>
                public byte DYNAMIC_ADDRESS {
                    get
                    {
                        byte temp = 0;
                        temp = (byte)(temp | (byte)memory[spanBegin + 12]);
                        return temp;
                    }
                    set
                    {
                        memory[spanBegin + 12] = (byte)value;
                    }
                }

                public Dct_DctMemoryWrapper(byte[] memory, long spanBegin)
                {
                    this.memory = memory;
                    this.spanBegin = spanBegin;
                }
            }
        }
    }
}
