﻿param($installPath, $toolsPath, $package, $project)

$analyzersDir = Join-Path (Split-Path -Path $toolsPath -Parent) "analyzers"
if (-Not (Test-Path $analyzersDir))
{
    return
}

$analyzersPaths = Join-Path ( $analyzersDir ) * -Resolve

foreach($analyzersPath in $analyzersPaths)
{
    # Install the language agnostic analyzers.
    if (Test-Path $analyzersPath)
    {
        foreach ($analyzerFilePath in Get-ChildItem $analyzersPath -Filter *.dll)
        {
            if($project.Object.AnalyzerReferences)
            {
                $project.Object.AnalyzerReferences.Add($analyzerFilePath.FullName)
            }
        }
    }
}

# $project.Type gives the language name like (C# or VB.NET)
$languageFolder = ""
if($project.Type -eq "C#")
{
    $languageFolder = "cs"
}
if($project.Type -eq "VB.NET")
{
    $languageFolder = "vb"
}
if($languageFolder -eq "")
{
    return
}

foreach($analyzersPath in $analyzersPaths)
{
    # Install language specific analyzers.
    $languageAnalyzersPath = join-path $analyzersPath $languageFolder
    if (Test-Path $languageAnalyzersPath)
    {
        foreach ($analyzerFilePath in Get-ChildItem $languageAnalyzersPath -Filter *.dll)
        {
            if($project.Object.AnalyzerReferences)
            {
                $project.Object.AnalyzerReferences.Add($analyzerFilePath.FullName)
            }
        }
    }
}
# SIG # Begin signature block
# MIIojQYJKoZIhvcNAQcCoIIofjCCKHoCAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCCh1voBODYpfCet
# zwmmor0XvG3ngI9/l8E/7NCzPBjyWaCCDfAwggZuMIIEVqADAgECAhMzAAADBU1i
# DWiFB6ozAAAAAAMFMA0GCSqGSIb3DQEBDAUAMH4xCzAJBgNVBAYTAlVTMRMwEQYD
# VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNy
# b3NvZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29mdCBDb2RlIFNpZ25p
# bmcgUENBIDIwMTEwHhcNMjIwODA0MjAyMzU3WhcNMjMwODAzMjAyMzU3WjBjMQsw
# CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
# ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYDVQQDEwQuTkVU
# MIIBojANBgkqhkiG9w0BAQEFAAOCAY8AMIIBigKCAYEAuBPUn3y4+hrXB6JCyc4U
# ffIv1VytDkksYhlPnRkUmnhw6lD6Ae1HHFUTz2E+JM/MsBFUdq5tc2h1mwGZaTg9
# tY2Q/CbRoqKzTa43vUVqun065znQ/OfUNP5Hf57dqFcuG0LmaVNoJmIngBTduXJq
# pAsot4lremrIcGcmJfJI0GuEsGSV6C4MuKoEtrOIJZtAsAiUtSXKkj9y60QKsMpT
# j9/s8cz7WBRB0r5Zmcf/63zagBjRVcbelQxnO/dTKw07gJLVoUCNAblyN0m5LzXa
# frnyY5Ig/AXnOZ9ogfXiqH9c/J+LRrpZ1lpkhG2Hd2c/1VwY3WwNK5xFX+ej35pI
# +pbK3X2Kk3iOK4kgtQeGb7d56S3YoZopbKzbCGzATVGQGgCrsaa8Uite9wQHSaoz
# /T1sh+C+SM3nTP/leYyXKuq2YPQV75XUNNt87KF0Fmm3gbZxuord6gVSgkjK2fc3
# TrMgFPSR3wFVYNYo5OLRUexfHxy8cMoMs4vmIrZERyJvAgMBAAGjggF+MIIBejAf
# BgNVHSUEGDAWBgorBgEEAYI3TAgBBggrBgEFBQcDAzAdBgNVHQ4EFgQUw8YZ5PLP
# dj4XQBBwk4pybOKrVhswUAYDVR0RBEkwR6RFMEMxKTAnBgNVBAsTIE1pY3Jvc29m
# dCBPcGVyYXRpb25zIFB1ZXJ0byBSaWNvMRYwFAYDVQQFEw00NjQyMjMrNDcyMjM3
# MB8GA1UdIwQYMBaAFEhuZOVQBdOCqhc3NyK1bajKdQKVMFQGA1UdHwRNMEswSaBH
# oEWGQ2h0dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2lvcHMvY3JsL01pY0NvZFNp
# Z1BDQTIwMTFfMjAxMS0wNy0wOC5jcmwwYQYIKwYBBQUHAQEEVTBTMFEGCCsGAQUF
# BzAChkVodHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NlcnRzL01pY0Nv
# ZFNpZ1BDQTIwMTFfMjAxMS0wNy0wOC5jcnQwDAYDVR0TAQH/BAIwADANBgkqhkiG
# 9w0BAQwFAAOCAgEAaEpKeazIa/JwvoPDi6rfAO3B0z+FJsbpvk2rFS0igT1MxPhS
# qP41a1h+sHT26rw7PGQsedoR5zX3HkTJXHL4MGlubM1Tf/jr2oXiTKnQU2MImWYW
# AWjEs0XOKzEp5NfDWkWmkzkDEcb79Woh1CU4JtzadNIkurFqDgbcn5+wQTq7LDHD
# o3F+J5EHMAl3YcY8tRWm3zsYuSU2OzLENQliTEW2CSPWSEarAgbpk2Rshc+zFHxL
# 2iIqoA/vVxkTA3r5Oec8ii2pd4GwL66sv80Hw1bEER6elUUUXjM1d3exuZvgf/rr
# wMpBog/lCbQiB7aebGBcA+r0I9hlrBc6/E6E4WCJTcC0sUAr85z6yCRcJ4tfYDpE
# qrxKqDAfC2NZdq+LIROgMXBIx16X7L73BJmiRcHCv7tOMYu5GKed1QaOJW0lT+uz
# P/L3ELlOI6foECPBcHQSS2gzR09xO7d30ALSraDKUTBM8B19JukAEb4g8cSC06gP
# FIHFQZyF0QSXKSVzDPoLygZJdHoJUYdXtBb5wfTcL0MfucEGECFQiiOoJjApv1vw
# ZqbbluutQXB/y2jl1ctnXgdh5ED1zoAfYIHCITgAE+k6r+LKkZaKXxXKDdR/ouaA
# AQwzFlgu02DkZsze1xNbYzcLQRkUimK5PjeG+by40elcBk/c8nfIJznJHT0wggd6
# MIIFYqADAgECAgphDpDSAAAAAAADMA0GCSqGSIb3DQEBCwUAMIGIMQswCQYDVQQG
# EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwG
# A1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMTIwMAYDVQQDEylNaWNyb3NvZnQg
# Um9vdCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkgMjAxMTAeFw0xMTA3MDgyMDU5MDla
# Fw0yNjA3MDgyMTA5MDlaMH4xCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5n
# dG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9y
# YXRpb24xKDAmBgNVBAMTH01pY3Jvc29mdCBDb2RlIFNpZ25pbmcgUENBIDIwMTEw
# ggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQCr8PpyEBwurdhuqoIQTTS6
# 8rZYIZ9CGypr6VpQqrgGOBoESbp/wwwe3TdrxhLYC/A4wpkGsMg51QEUMULTiQ15
# ZId+lGAkbK+eSZzpaF7S35tTsgosw6/ZqSuuegmv15ZZymAaBelmdugyUiYSL+er
# CFDPs0S3XdjELgN1q2jzy23zOlyhFvRGuuA4ZKxuZDV4pqBjDy3TQJP4494HDdVc
# eaVJKecNvqATd76UPe/74ytaEB9NViiienLgEjq3SV7Y7e1DkYPZe7J7hhvZPrGM
# XeiJT4Qa8qEvWeSQOy2uM1jFtz7+MtOzAz2xsq+SOH7SnYAs9U5WkSE1JcM5bmR/
# U7qcD60ZI4TL9LoDho33X/DQUr+MlIe8wCF0JV8YKLbMJyg4JZg5SjbPfLGSrhwj
# p6lm7GEfauEoSZ1fiOIlXdMhSz5SxLVXPyQD8NF6Wy/VI+NwXQ9RRnez+ADhvKwC
# gl/bwBWzvRvUVUvnOaEP6SNJvBi4RHxF5MHDcnrgcuck379GmcXvwhxX24ON7E1J
# MKerjt/sW5+v/N2wZuLBl4F77dbtS+dJKacTKKanfWeA5opieF+yL4TXV5xcv3co
# KPHtbcMojyyPQDdPweGFRInECUzF1KVDL3SV9274eCBYLBNdYJWaPk8zhNqwiBfe
# nk70lrC8RqBsmNLg1oiMCwIDAQABo4IB7TCCAekwEAYJKwYBBAGCNxUBBAMCAQAw
# HQYDVR0OBBYEFEhuZOVQBdOCqhc3NyK1bajKdQKVMBkGCSsGAQQBgjcUAgQMHgoA
# UwB1AGIAQwBBMAsGA1UdDwQEAwIBhjAPBgNVHRMBAf8EBTADAQH/MB8GA1UdIwQY
# MBaAFHItOgIxkEO5FAVO4eqnxzHRI4k0MFoGA1UdHwRTMFEwT6BNoEuGSWh0dHA6
# Ly9jcmwubWljcm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL01pY1Jvb0NlckF1
# dDIwMTFfMjAxMV8wM18yMi5jcmwwXgYIKwYBBQUHAQEEUjBQME4GCCsGAQUFBzAC
# hkJodHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY1Jvb0NlckF1
# dDIwMTFfMjAxMV8wM18yMi5jcnQwgZ8GA1UdIASBlzCBlDCBkQYJKwYBBAGCNy4D
# MIGDMD8GCCsGAQUFBwIBFjNodHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpb3Bz
# L2RvY3MvcHJpbWFyeWNwcy5odG0wQAYIKwYBBQUHAgIwNB4yIB0ATABlAGcAYQBs
# AF8AcABvAGwAaQBjAHkAXwBzAHQAYQB0AGUAbQBlAG4AdAAuIB0wDQYJKoZIhvcN
# AQELBQADggIBAGfyhqWY4FR5Gi7T2HRnIpsLlhHhY5KZQpZ90nkMkMFlXy4sPvjD
# ctFtg/6+P+gKyju/R6mj82nbY78iNaWXXWWEkH2LRlBV2AySfNIaSxzzPEKLUtCw
# /WvjPgcuKZvmPRul1LUdd5Q54ulkyUQ9eHoj8xN9ppB0g430yyYCRirCihC7pKkF
# DJvtaPpoLpWgKj8qa1hJYx8JaW5amJbkg/TAj/NGK978O9C9Ne9uJa7lryft0N3z
# Dq+ZKJeYTQ49C/IIidYfwzIY4vDFLc5bnrRJOQrGCsLGra7lstnbFYhRRVg4MnEn
# Gn+x9Cf43iw6IGmYslmJaG5vp7d0w0AFBqYBKig+gj8TTWYLwLNN9eGPfxxvFX1F
# p3blQCplo8NdUmKGwx1jNpeG39rz+PIWoZon4c2ll9DuXWNB41sHnIc+BncG0Qax
# dR8UvmFhtfDcxhsEvt9Bxw4o7t5lL+yX9qFcltgA1qFGvVnzl6UJS0gQmYAf0AAp
# xbGbpT9Fdx41xtKiop96eiL6SJUfq/tHI4D1nvi/a7dLl+LrdXga7Oo3mXkYS//W
# syNodeav+vyL6wuA6mk7r/ww7QRMjt/fdW1jkT3RnVZOT7+AVyKheBEyIXrvQQqx
# P/uozKRdwaGIm1dxVk5IRcBCyZt2WwqASGv9eZ/BvW1taslScxMNelDNMYIZ8zCC
# Ge8CAQEwgZUwfjELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAO
# BgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEo
# MCYGA1UEAxMfTWljcm9zb2Z0IENvZGUgU2lnbmluZyBQQ0EgMjAxMQITMwAAAwVN
# Yg1ohQeqMwAAAAADBTANBglghkgBZQMEAgEFAKCBrjAZBgkqhkiG9w0BCQMxDAYK
# KwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYKKwYBBAGCNwIBFTAvBgkqhkiG
# 9w0BCQQxIgQgscbk7KKN8M4zlvGIkWbJVqzLt3vnYcsDip+8ebtDMX0wQgYKKwYB
# BAGCNwIBDDE0MDKgFIASAE0AaQBjAHIAbwBzAG8AZgB0oRqAGGh0dHA6Ly93d3cu
# bWljcm9zb2Z0LmNvbTANBgkqhkiG9w0BAQEFAASCAYCtiUdA/7rtiC2ePyaCPPBM
# 1+6SOmVJ2xg2Nk9s4z4cdnLKqxPMXal6fBjYJ0khzObNpJ8hiVKXrSi9Xmffgv3Y
# YJ13eEtAq+ZaiHnULDF+0wLRcDTmD02AoGDcXfFlYRb7yNtspMWKhtEfdxuRwia4
# nGg143gZH6uUKRUjGcFVY+QU8sBP31klUjMX9u75aLxcm8Nc9KBi7AI+1DtxmVJC
# E2omAd2WB4bv+E46DgVGGlHIX0W0gzK4OJWqHj0bwZgOFA+ZgjE8p+vnqPe5szqZ
# brKDAXRs+o+fErelffGXddMOfLLkLHW8Gs5i3WbVzi8l4wws6fClgsPs709vxXi9
# daxDAWvY8Wk6PkW1sagrxpmRi2RYM8ZRQr1zzXszC3jAs/zL5zo3yy2MEqvphjR5
# lQYZUfJbXuKX0aPmH+LO8Pj9WXKtj3rxIdcq0Xw60GHibAeSmVJunSl/F30eVjhh
# Z+e+SmnTOQ3JSFCch5Qh1wkIs/5s4UGGYWRjFCY6t/Whghb9MIIW+QYKKwYBBAGC
# NwMDATGCFukwghblBgkqhkiG9w0BBwKgghbWMIIW0gIBAzEPMA0GCWCGSAFlAwQC
# AQUAMIIBUQYLKoZIhvcNAQkQAQSgggFABIIBPDCCATgCAQEGCisGAQQBhFkKAwEw
# MTANBglghkgBZQMEAgEFAAQgFAYVx8HLJA9URS16AK5BzJ3N6FfXABA0t43JQH5O
# oW4CBmO/8GitIxgTMjAyMzAxMTcxMzExMDcuNjI5WjAEgAIB9KCB0KSBzTCByjEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1v
# bmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjElMCMGA1UECxMcTWlj
# cm9zb2Z0IEFtZXJpY2EgT3BlcmF0aW9uczEmMCQGA1UECxMdVGhhbGVzIFRTUyBF
# U046RDZCRC1FM0U3LTE2ODUxJTAjBgNVBAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1w
# IFNlcnZpY2WgghFUMIIHDDCCBPSgAwIBAgITMwAAAcf7AKBKW/In3AABAAABxzAN
# BgkqhkiG9w0BAQsFADB8MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3Rv
# bjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
# aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0EgMjAxMDAeFw0y
# MjExMDQxOTAxMzVaFw0yNDAyMDIxOTAxMzVaMIHKMQswCQYDVQQGEwJVUzETMBEG
# A1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWlj
# cm9zb2Z0IENvcnBvcmF0aW9uMSUwIwYDVQQLExxNaWNyb3NvZnQgQW1lcmljYSBP
# cGVyYXRpb25zMSYwJAYDVQQLEx1UaGFsZXMgVFNTIEVTTjpENkJELUUzRTctMTY4
# NTElMCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUtU3RhbXAgU2VydmljZTCCAiIwDQYJ
# KoZIhvcNAQEBBQADggIPADCCAgoCggIBAK9C3FbZ2rTRTAa0E7RvT/CEgD8shpsT
# X4RM2jlZbdPPKQVBQCGrJjf3jooxOlHGn93Nm1Zzf9NoodLJkqmJJuT92cFO2Vtt
# Nm+nDwyY13K4yY9Kn57nHAbRN1lNL2fAokA+6qysXhfGATXEvj1bb7KoXeWFugMI
# VqoY8NZmLi3rReW+mj4n/90c5cqht0le0D4kiXp3bO4BuN+UbMtRyeF56s7TiUeN
# SNI9xENOSTBeUDUYu5E+r100/jB1Y9uxVUO23n/1PthAGxY9l9gDlm74JWGmJzN5
# vyPzlgx1IBsPCiHbA4d1tXrrJxdg+6HpxoLWobPktRuVKJX+REoP/Wft/K4UMC4K
# JGOZOqfJOWq2FrbM3SSuiYiEZfONx++JO/kKpU9i2wED6vIr0L9IHXJVtmibp9Sq
# 1vr+dkd7wBwjrW1Jsbw9XjRh6hqi2oLZavVBVyl7l56lyaq7gmJn8HRTA9FD+oot
# ZRXXii/Oz3Y3QMMgolXAhKC57w88r4zY8bZE3c+keMhdTf1+D0kB+BZYLJcgSF4I
# GkpT7bz7sQLbmnPyE4+JNCEUoRomCwTNg8OqHrCzqMXtOzlDzvql1znCTFR4RNDJ
# YYZ8XzdgdSVhT1sEOqKFoqgDkA6s3A8fu/bIcQNQsdCu9HjgaZTKINu4GKC6Qb+5
# 0c+LR6qE8rwNAgMBAAGjggE2MIIBMjAdBgNVHQ4EFgQUBVDS3Rw+wQBf1VP1/3hB
# y4lEkiAwHwYDVR0jBBgwFoAUn6cVXQBeYl2D9OXSZacbUzUZ6XIwXwYDVR0fBFgw
# VjBUoFKgUIZOaHR0cDovL3d3dy5taWNyb3NvZnQuY29tL3BraW9wcy9jcmwvTWlj
# cm9zb2Z0JTIwVGltZS1TdGFtcCUyMFBDQSUyMDIwMTAoMSkuY3JsMGwGCCsGAQUF
# BwEBBGAwXjBcBggrBgEFBQcwAoZQaHR0cDovL3d3dy5taWNyb3NvZnQuY29tL3Br
# aW9wcy9jZXJ0cy9NaWNyb3NvZnQlMjBUaW1lLVN0YW1wJTIwUENBJTIwMjAxMCgx
# KS5jcnQwDAYDVR0TAQH/BAIwADATBgNVHSUEDDAKBggrBgEFBQcDCDANBgkqhkiG
# 9w0BAQsFAAOCAgEA0MuXPKID9MvMQLC1XGtO8FstZk/p6mIABZ89ve9pDTviiewB
# OH/klW7zp5Hnrjj6t8XPuk0vINxbiimBMGKr50R8V+fLY5bHGbGXip7u3xjVJaTU
# /WzkBR1gC1EbqF6fEyx4cY9zxKvY8xWAT9mDTC6Je9KI2Naqc3t5zDCX6Xbq3QQa
# Wji5SZkTUy4cXfkSRiUG2NVwHMeqfxYoMKgWrEg1MaftMhTxAQfbgRNyiCwLaun3
# MxqeBDHqJ+mJpMghgLVzCgxUEIHT/yE3u1YIQFWz01ZT94WNXRYHPrfGCtqGxUhV
# SrJZAEgEwx7pQjIbflqyLLpHJRFD/Q2jJqau0tESzgzInCOj7aqhjoXZ2kZbQNHf
# ln/tLT7fUlFbazycju1jDym8pAkV85hytOs69JJ9WIlGDVwrDoGhxeSJjtmcEOeF
# BNSOeY41HZXco8v1DyYMUZvTcl3ju2nWK/CvH+kNpzxdL1qhRu3sMGgJeQpSnq87
# IX4QfM7o1UdHdUWu2dNZZ12IVrj6lWWshZeyR6+ouoboaVOgUOv1YGNHAYpLF+Jj
# TPiEmPNU9UWLe31gEzbv85IyDXM4qc234OUvt3wgKPIFQevugOS9LwYN/XbBSE7+
# jFibkPGWcu38JRQWROHeSBW0bnWpDcChncixjNqLWjau8Jt5Lu8eNVBgJpAwggdx
# MIIFWaADAgECAhMzAAAAFcXna54Cm0mZAAAAAAAVMA0GCSqGSIb3DQEBCwUAMIGI
# MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
# bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMTIwMAYDVQQDEylN
# aWNyb3NvZnQgUm9vdCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkgMjAxMDAeFw0yMTA5
# MzAxODIyMjVaFw0zMDA5MzAxODMyMjVaMHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQI
# EwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
# ZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBD
# QSAyMDEwMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA5OGmTOe0ciEL
# eaLL1yR5vQ7VgtP97pwHB9KpbE51yMo1V/YBf2xK4OK9uT4XYDP/XE/HZveVU3Fa
# 4n5KWv64NmeFRiMMtY0Tz3cywBAY6GB9alKDRLemjkZrBxTzxXb1hlDcwUTIcVxR
# MTegCjhuje3XD9gmU3w5YQJ6xKr9cmmvHaus9ja+NSZk2pg7uhp7M62AW36MEByd
# Uv626GIl3GoPz130/o5Tz9bshVZN7928jaTjkY+yOSxRnOlwaQ3KNi1wjjHINSi9
# 47SHJMPgyY9+tVSP3PoFVZhtaDuaRr3tpK56KTesy+uDRedGbsoy1cCGMFxPLOJi
# ss254o2I5JasAUq7vnGpF1tnYN74kpEeHT39IM9zfUGaRnXNxF803RKJ1v2lIH1+
# /NmeRd+2ci/bfV+AutuqfjbsNkz2K26oElHovwUDo9Fzpk03dJQcNIIP8BDyt0cY
# 7afomXw/TNuvXsLz1dhzPUNOwTM5TI4CvEJoLhDqhFFG4tG9ahhaYQFzymeiXtco
# dgLiMxhy16cg8ML6EgrXY28MyTZki1ugpoMhXV8wdJGUlNi5UPkLiWHzNgY1GIRH
# 29wb0f2y1BzFa/ZcUlFdEtsluq9QBXpsxREdcu+N+VLEhReTwDwV2xo3xwgVGD94
# q0W29R6HXtqPnhZyacaue7e3PmriLq0CAwEAAaOCAd0wggHZMBIGCSsGAQQBgjcV
# AQQFAgMBAAEwIwYJKwYBBAGCNxUCBBYEFCqnUv5kxJq+gpE8RjUpzxD/LwTuMB0G
# A1UdDgQWBBSfpxVdAF5iXYP05dJlpxtTNRnpcjBcBgNVHSAEVTBTMFEGDCsGAQQB
# gjdMg30BATBBMD8GCCsGAQUFBwIBFjNodHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20v
# cGtpb3BzL0RvY3MvUmVwb3NpdG9yeS5odG0wEwYDVR0lBAwwCgYIKwYBBQUHAwgw
# GQYJKwYBBAGCNxQCBAweCgBTAHUAYgBDAEEwCwYDVR0PBAQDAgGGMA8GA1UdEwEB
# /wQFMAMBAf8wHwYDVR0jBBgwFoAU1fZWy4/oolxiaNE9lJBb186aGMQwVgYDVR0f
# BE8wTTBLoEmgR4ZFaHR0cDovL2NybC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJv
# ZHVjdHMvTWljUm9vQ2VyQXV0XzIwMTAtMDYtMjMuY3JsMFoGCCsGAQUFBwEBBE4w
# TDBKBggrBgEFBQcwAoY+aHR0cDovL3d3dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0
# cy9NaWNSb29DZXJBdXRfMjAxMC0wNi0yMy5jcnQwDQYJKoZIhvcNAQELBQADggIB
# AJ1VffwqreEsH2cBMSRb4Z5yS/ypb+pcFLY+TkdkeLEGk5c9MTO1OdfCcTY/2mRs
# fNB1OW27DzHkwo/7bNGhlBgi7ulmZzpTTd2YurYeeNg2LpypglYAA7AFvonoaeC6
# Ce5732pvvinLbtg/SHUB2RjebYIM9W0jVOR4U3UkV7ndn/OOPcbzaN9l9qRWqveV
# tihVJ9AkvUCgvxm2EhIRXT0n4ECWOKz3+SmJw7wXsFSFQrP8DJ6LGYnn8AtqgcKB
# GUIZUnWKNsIdw2FzLixre24/LAl4FOmRsqlb30mjdAy87JGA0j3mSj5mO0+7hvoy
# GtmW9I/2kQH2zsZ0/fZMcm8Qq3UwxTSwethQ/gpY3UA8x1RtnWN0SCyxTkctwRQE
# cb9k+SS+c23Kjgm9swFXSVRk2XPXfx5bRAGOWhmRaw2fpCjcZxkoJLo4S5pu+yFU
# a2pFEUep8beuyOiJXk+d0tBMdrVXVAmxaQFEfnyhYWxz/gq77EFmPWn9y8FBSX5+
# k77L+DvktxW/tM4+pTFRhLy/AsGConsXHRWJjXD+57XQKBqJC4822rpM+Zv/Cuk0
# +CQ1ZyvgDbjmjJnW4SLq8CdCPSWU5nR0W2rRnj7tfqAxM328y+l7vzhwRNGQ8cir
# Ooo6CGJ/2XBjU02N7oJtpQUQwXEGahC0HVUzWLOhcGbyoYICyzCCAjQCAQEwgfih
# gdCkgc0wgcoxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYD
# VQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJTAj
# BgNVBAsTHE1pY3Jvc29mdCBBbWVyaWNhIE9wZXJhdGlvbnMxJjAkBgNVBAsTHVRo
# YWxlcyBUU1MgRVNOOkQ2QkQtRTNFNy0xNjg1MSUwIwYDVQQDExxNaWNyb3NvZnQg
# VGltZS1TdGFtcCBTZXJ2aWNloiMKAQEwBwYFKw4DAhoDFQDiAEj9CUm7+Udt8MXI
# kIrx8nJGKKCBgzCBgKR+MHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5n
# dG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9y
# YXRpb24xJjAkBgNVBAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAyMDEwMA0G
# CSqGSIb3DQEBBQUAAgUA53EGRzAiGA8yMDIzMDExNzE5MzQzMVoYDzIwMjMwMTE4
# MTkzNDMxWjB0MDoGCisGAQQBhFkKBAExLDAqMAoCBQDncQZHAgEAMAcCAQACAgNN
# MAcCAQACAhG2MAoCBQDnclfHAgEAMDYGCisGAQQBhFkKBAIxKDAmMAwGCisGAQQB
# hFkKAwKgCjAIAgEAAgMHoSChCjAIAgEAAgMBhqAwDQYJKoZIhvcNAQEFBQADgYEA
# LAklmlb5yFtY7RbQ1N9YGn6dLvvM1bvAB+jmOpdZXnJoOVMCeOQM6vni+G7eZEcP
# O3owv55UwJ3JL57S9n5egpbHX6KQBHi9T5VxiiKi+AQKeWVF/0f+aDRtBIMwKnrD
# qDgiTW2GrFJLj0YWCyzP3M1fDzzui7pL/oDnRoFfphgxggQNMIIECQIBATCBkzB8
# MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
# bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSYwJAYDVQQDEx1N
# aWNyb3NvZnQgVGltZS1TdGFtcCBQQ0EgMjAxMAITMwAAAcf7AKBKW/In3AABAAAB
# xzANBglghkgBZQMEAgEFAKCCAUowGgYJKoZIhvcNAQkDMQ0GCyqGSIb3DQEJEAEE
# MC8GCSqGSIb3DQEJBDEiBCBTiWU7hZGnnheDQ/3Sh2xMucYTIyLVh0efFSK1fVFK
# XjCB+gYLKoZIhvcNAQkQAi8xgeowgecwgeQwgb0EIEfn5dviUrJFCznlWC23jIJO
# x3SG0RJgLI8LXMujCZLJMIGYMIGApH4wfDELMAkGA1UEBhMCVVMxEzARBgNVBAgT
# Cldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29m
# dCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENB
# IDIwMTACEzMAAAHH+wCgSlvyJ9wAAQAAAccwIgQgKASVC0uYz6LxhlbsCA+2sBzZ
# VBQbUqMLPmbx8rHg8iMwDQYJKoZIhvcNAQELBQAEggIAEvfocQRP8zKFlV1U/iM1
# FHk/aSzfgkURabc9BBTBDgauFFXgOkAUR15b3UyHgaBKUVzAJqG5aw0tNr5b1+eB
# Wu/F966+C8zAXIXDt6yifA5rRHOeAwbhiqhStjeG6S9FjSES7NgGKeIgGJZBSMrI
# Xwd7nwRmV250y7qkyQEzWXNxT4BtTTU9z/ZfoqG16zwe1HvNQhTyfvreAScDBpZK
# XHNenfgExWj/rB9/Q5f4ZvgRix5o+qr+g7L01/W1ivLLnR6QFIS7FA+9VNJwi0kc
# FiqoWn5Z6fIRYP+OhLvr7vgDupaUFHNqopyMT2M7WrA2mHa+eKj/hr+1uKl5Le/x
# h/Ts86XC8jMZOfsjwVIKS07vpcxeqE3W3CGI4CS6M6P4rd10qePVz0YI62VzO5Th
# HF4LX0luGtZWMAg6X68+VhJvmMQDURWdQGXm9lI8vKyQcaUKl5eoVGwEG9TAq2sg
# VOH38mq5gSAyhJwTZF3He+e6ilwlfbFmR3focynh+2iY95rRi3nhiWvlM9Hy6d6i
# F7Hm1PloTIg3ZklvqPedMgyyZykfBS12ToSqnlAiA4EG+kmPq9a6yK4XTdurZshU
# G3gXiiy0FwVnZIIawvpIGCUBzzXmx2mOLyHXONLc3LyxhYjccNEOvANvnk8RjTgZ
# 4d6VbpN8A53RvvgkbVhxzGk=
# SIG # End signature block
